/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.read.ListAppender;
import junit.framework.TestCase;
import org.apache.log4j.DummyObject;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.slf4j.LoggerFactory;

public class LoggerTest
extends TestCase {
    LoggerContext context;
    ListAppender<LoggingEvent> appender;
    ch.qos.logback.classic.Logger logbackLogger;
    Logger log4jLogger;

    public void setUp() throws Exception {
        this.context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.context.shutdownAndReset();
        this.appender = new ListAppender();
        this.appender.setContext((Context)this.context);
        this.appender.setName("listAppender");
        this.appender.start();
        ch.qos.logback.classic.Logger lbLogger = this.context.getLogger("root");
        lbLogger.addAppender(this.appender);
        this.log4jLogger = Logger.getLogger(LoggerTest.class);
        this.logbackLogger = this.context.getLogger(LoggerTest.class);
        super.setUp();
    }

    public void tearDown() throws Exception {
        this.appender.stop();
        this.context.stop();
        this.appender = null;
        this.context = null;
        this.logbackLogger = null;
        this.log4jLogger = null;
        super.tearDown();
    }

    public void testLogWithObjectMessages() {
        this.log4jLogger.debug((Object)"test");
        LoggingEvent event = (LoggingEvent)this.appender.list.get(0);
        LoggerTest.assertEquals((String)"test", (String)event.getMessage());
        this.appender.list.clear();
        this.log4jLogger.debug(null);
        event = (LoggingEvent)this.appender.list.get(0);
        LoggerTest.assertEquals(null, (String)event.getMessage());
        this.appender.list.clear();
        DummyObject dummy = new DummyObject();
        this.log4jLogger.debug((Object)dummy);
        event = (LoggingEvent)this.appender.list.get(0);
        LoggerTest.assertEquals((String)dummy.toString(), (String)event.getMessage());
        this.appender.list.clear();
    }

    public void testIsEnabledAPI() {
        LoggerTest.assertTrue((boolean)this.log4jLogger.isTraceEnabled());
        LoggerTest.assertTrue((boolean)this.log4jLogger.isDebugEnabled());
        LoggerTest.assertTrue((boolean)this.log4jLogger.isInfoEnabled());
        LoggerTest.assertTrue((boolean)this.log4jLogger.isWarnEnabled());
        LoggerTest.assertTrue((boolean)this.log4jLogger.isErrorEnabled());
    }

    public void testPrintAPI() {
        Exception e = new Exception("just testing");
        this.log4jLogger.trace(null);
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.debug(null);
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.debug((Object)"debug message");
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.info(null);
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.info((Object)"info  message");
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.warn(null);
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.warn((Object)"warn message");
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.error(null);
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.error((Object)"error message");
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.debug(null, (Throwable)e);
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.debug((Object)"debug message", (Throwable)e);
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.info(null, (Throwable)e);
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.info((Object)"info  message", (Throwable)e);
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.warn(null, (Throwable)e);
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.warn((Object)"warn message", (Throwable)e);
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.error(null, (Throwable)e);
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
        this.log4jLogger.error((Object)"error message", (Throwable)e);
        LoggerTest.assertEquals((int)1, (int)this.appender.list.size());
        this.appender.list.clear();
    }

    public void testLogAPI() {
        this.log4jLogger.log("x", (Priority)Level.TRACE, (Object)"x", null);
        LoggerTest.assertEquals((int)0, (int)this.appender.list.size());
        this.log4jLogger.log("x", (Priority)Level.DEBUG, (Object)"x", null);
        this.log4jLogger.log("x", (Priority)Level.INFO, (Object)"x", null);
        this.log4jLogger.log("x", (Priority)Level.WARN, (Object)"x", null);
        this.log4jLogger.log("x", (Priority)Level.ERROR, (Object)"x", null);
        this.log4jLogger.log("x", (Priority)Level.FATAL, (Object)"x", null);
        LoggerTest.assertEquals((int)5, (int)this.appender.list.size());
        this.appender.list.clear();
    }
}

