/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access;

import ch.qos.logback.access.AccessLayout;
import ch.qos.logback.access.pattern.ContentLengthConverter;
import ch.qos.logback.access.pattern.DateConverter;
import ch.qos.logback.access.pattern.LineSeparatorConverter;
import ch.qos.logback.access.pattern.LocalIPAddressConverter;
import ch.qos.logback.access.pattern.NAConverter;
import ch.qos.logback.access.pattern.RemoteHostConverter;
import ch.qos.logback.access.pattern.RemoteIPAddressConverter;
import ch.qos.logback.access.pattern.RemoteUserConverter;
import ch.qos.logback.access.pattern.RequestHeaderConverter;
import ch.qos.logback.access.pattern.RequestMethodConverter;
import ch.qos.logback.access.pattern.RequestProtocolConverter;
import ch.qos.logback.access.pattern.RequestURIConverter;
import ch.qos.logback.access.pattern.RequestURLConverter;
import ch.qos.logback.access.pattern.ServerNameConverter;
import ch.qos.logback.access.pattern.StatusCodeConverter;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import java.util.HashMap;
import java.util.Map;

public class PatternLayout
extends PatternLayoutBase
implements AccessLayout {
    static final Map<String, String> defaultConverterMap = new HashMap<String, String>();
    public static String CLF_PATTERN = "%h %l %u %t \"%r\" %s %b";

    public PatternLayout() {
        this.setPattern(CLF_PATTERN);
    }

    public Map getDefaultConverterMap() {
        return defaultConverterMap;
    }

    protected void postCompileProcessing(Converter head) {
        Converter tail = PatternLayout.findTail((Converter)head);
        LineSeparatorConverter newLineConverter = new LineSeparatorConverter();
        if (tail == null) {
            head = newLineConverter;
        } else {
            tail.setNext((Converter)newLineConverter);
        }
        this.setContextForConverters((Converter)head);
    }

    public String doLayout(AccessEvent event) {
        if (!this.isStarted()) {
            return null;
        }
        return this.writeLoopOnConverters(event);
    }

    public String doLayout(Object o) {
        return this.doLayout((AccessEvent)o);
    }

    static {
        defaultConverterMap.put("a", RemoteIPAddressConverter.class.getName());
        defaultConverterMap.put("remoteIP", RemoteIPAddressConverter.class.getName());
        defaultConverterMap.put("A", LocalIPAddressConverter.class.getName());
        defaultConverterMap.put("localIP", LocalIPAddressConverter.class.getName());
        defaultConverterMap.put("b", ContentLengthConverter.class.getName());
        defaultConverterMap.put("B", ContentLengthConverter.class.getName());
        defaultConverterMap.put("bytesSent", ContentLengthConverter.class.getName());
        defaultConverterMap.put("h", RemoteHostConverter.class.getName());
        defaultConverterMap.put("clientHost", RemoteHostConverter.class.getName());
        defaultConverterMap.put("H", RequestProtocolConverter.class.getName());
        defaultConverterMap.put("protocol", RequestProtocolConverter.class.getName());
        defaultConverterMap.put("i", RequestHeaderConverter.class.getName());
        defaultConverterMap.put("header", RequestHeaderConverter.class.getName());
        defaultConverterMap.put("l", NAConverter.class.getName());
        defaultConverterMap.put("m", RequestMethodConverter.class.getName());
        defaultConverterMap.put("r", RequestURLConverter.class.getName());
        defaultConverterMap.put("requestURL", RequestURLConverter.class.getName());
        defaultConverterMap.put("s", StatusCodeConverter.class.getName());
        defaultConverterMap.put("statusCode", StatusCodeConverter.class.getName());
        defaultConverterMap.put("t", DateConverter.class.getName());
        defaultConverterMap.put("u", RemoteUserConverter.class.getName());
        defaultConverterMap.put("U", RequestURIConverter.class.getName());
        defaultConverterMap.put("v", ServerNameConverter.class.getName());
    }
}

