/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.spi;

import com.caucho.server.connection.AbstractHttpResponse;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Response;

public class AccessEvent
implements Serializable {
    private static final long serialVersionUID = -3118194368414470960L;
    public static final String NA = "-";
    public static final int SENTINEL = -1;
    private final transient HttpServletRequest httpRequest;
    private final transient HttpServletResponse httpResponse;
    String requestURI;
    String requestURL;
    String remoteHost;
    String remoteUser;
    String remoteAddr;
    String protocol;
    String method;
    String serverName;
    Map headerMap;
    long contentLength = -1L;
    int statusCode = -1;
    int localPort = -1;
    private long timeStamp = 0L;

    public AccessEvent(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.timeStamp = System.currentTimeMillis();
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        if (this.timeStamp != 0L) {
            throw new IllegalStateException("timeStamp has been already set for this event.");
        }
        this.timeStamp = timeStamp;
    }

    public String getRequestURI() {
        if (this.requestURI == null) {
            this.requestURI = this.httpRequest != null ? this.httpRequest.getRequestURI() : NA;
        }
        return this.requestURI;
    }

    public String getRequestURL() {
        if (this.requestURL == null) {
            if (this.httpRequest != null) {
                StringBuffer buf = new StringBuffer();
                buf.append(this.httpRequest.getMethod());
                buf.append(' ');
                buf.append(this.httpRequest.getRequestURI());
                String qStr = this.httpRequest.getQueryString();
                if (qStr != null) {
                    buf.append('?');
                    buf.append(qStr);
                }
                buf.append(' ');
                buf.append(this.httpRequest.getProtocol());
                this.requestURL = buf.toString();
            } else {
                this.requestURL = NA;
            }
        }
        return this.requestURL;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.remoteHost = this.httpRequest != null ? this.httpRequest.getRemoteHost() : NA;
        }
        return this.remoteHost;
    }

    public String getRemoteUser() {
        if (this.remoteUser == null) {
            this.remoteUser = this.httpRequest != null ? this.httpRequest.getRemoteUser() : NA;
        }
        return this.remoteUser;
    }

    public String getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.httpRequest != null ? this.httpRequest.getProtocol() : NA;
        }
        return this.protocol;
    }

    public String getMethod() {
        if (this.method == null) {
            this.method = this.httpRequest != null ? this.httpRequest.getMethod() : NA;
        }
        return this.method;
    }

    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = this.httpRequest != null ? this.httpRequest.getServerName() : NA;
        }
        return this.serverName;
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.remoteAddr = this.httpRequest != null ? this.httpRequest.getRemoteAddr() : NA;
        }
        return this.remoteAddr;
    }

    public String getHeader(String key) {
        String result = null;
        if (this.headerMap == null) {
            if (this.httpRequest != null) {
                this.buildHeaderMap();
                result = (String)this.headerMap.get(key);
            }
        } else {
            result = (String)this.headerMap.get(key);
        }
        if (result != null) {
            return result;
        }
        return NA;
    }

    public void buildHeaderMap() {
        this.headerMap = new HashMap();
        Enumeration e = this.httpRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.headerMap.put(key, this.httpRequest.getHeader(key));
        }
    }

    public String getAttribute(String key) {
        if (this.httpRequest != null) {
            Object value = this.httpRequest.getAttribute(key);
            if (value == null) {
                return NA;
            }
            return value.toString();
        }
        return NA;
    }

    public String getCookie(String key) {
        if (this.httpRequest != null) {
            Cookie[] cookieArray = this.httpRequest.getCookies();
            if (cookieArray == null) {
                return NA;
            }
            for (int i = 0; cookieArray != null && i < cookieArray.length; ++i) {
                if (!key.equals(cookieArray[i].getName())) continue;
                return cookieArray[i].getValue();
            }
        }
        return NA;
    }

    public long getContentLength() {
        if (this.contentLength == -1L && this.httpResponse != null && !(this.httpResponse instanceof Response)) {
            if (this.httpResponse instanceof AbstractHttpResponse) {
                this.contentLength = ((AbstractHttpResponse)this.httpResponse).getContentLength();
            } else if (this.httpResponse instanceof org.apache.catalina.connector.Response) {
                this.contentLength = ((org.apache.catalina.connector.Response)this.httpResponse).getContentLength();
            }
        }
        return this.contentLength;
    }

    public int getStatusCode() {
        if (this.statusCode == -1 && this.httpResponse != null) {
            if (this.httpResponse instanceof Response) {
                this.statusCode = ((Response)this.httpResponse).getStatus();
            } else if (this.httpResponse instanceof AbstractHttpResponse) {
                this.statusCode = ((AbstractHttpResponse)this.httpResponse).getStatusCode();
            } else if (this.httpResponse instanceof org.apache.catalina.connector.Response) {
                this.statusCode = ((org.apache.catalina.connector.Response)this.httpResponse).getStatus();
            }
        }
        return this.statusCode;
    }

    public int getLocalPort() {
        if (this.localPort == -1 && this.httpRequest != null) {
            this.localPort = this.httpRequest.getLocalPort();
        }
        return this.localPort;
    }
}

