/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.JettyServerAdapter;
import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Response;

public class RequestLogImpl
extends ContextBase
implements RequestLog,
AppenderAttachable {
    public static final String DEFAULT_CONFIG_FILE = "etc" + File.separatorChar + "logback-access.xml";
    AppenderAttachableImpl aai = new AppenderAttachableImpl();
    String filename;

    public void log(Request jettyRequest, Response jettyResponse) {
        JettyServerAdapter adapter = new JettyServerAdapter(jettyRequest, jettyResponse);
        AccessEvent accessEvent = new AccessEvent((HttpServletRequest)jettyRequest, (HttpServletResponse)jettyResponse, adapter);
        this.aai.appendLoopOnAppenders((Object)accessEvent);
    }

    public void start() throws Exception {
        File configFile;
        if (this.filename == null) {
            String jettyHomeProperty = System.getProperty("jetty.home");
            this.filename = jettyHomeProperty + File.separatorChar + DEFAULT_CONFIG_FILE;
            this.getStatusManager().add((Status)new ErrorStatus("filename property not set. Assuming [" + this.filename + "]", (Object)this));
        }
        if ((configFile = new File(this.filename)).exists()) {
            JoranConfigurator jc = new JoranConfigurator();
            jc.setContext((Context)this);
            jc.doConfigure(this.filename);
            StatusPrinter.print((StatusManager)this.getStatusManager());
        } else {
            this.getStatusManager().add((Status)new ErrorStatus("[" + this.filename + "] does not exist", (Object)this));
        }
    }

    public void stop() throws Exception {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean isRunning() {
        return false;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public boolean isStarted() {
        return true;
    }

    public boolean isStarting() {
        return false;
    }

    public boolean isStopping() {
        return false;
    }

    public boolean isFailed() {
        return false;
    }

    public void addAppender(Appender newAppender) {
        this.aai.addAppender(newAppender);
    }

    public Iterator iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender appender) {
        return this.aai.detachAppender(appender);
    }

    public Appender detachAppender(String name) {
        return this.aai.detachAppender(name);
    }
}

