/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.spi;

import ch.qos.logback.access.spi.ServerAdapter;
import ch.qos.logback.access.spi.Util;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccessEvent
implements Serializable {
    private static final long serialVersionUID = -3118194368414470960L;
    public static final String NA = "-";
    public static final int SENTINEL = -1;
    private final transient HttpServletRequest httpRequest;
    private final transient HttpServletResponse httpResponse;
    String requestURI;
    String requestURL;
    String remoteHost;
    String remoteUser;
    String remoteAddr;
    String protocol;
    String method;
    String serverName;
    String postContent;
    Map<String, Object> requestHeaderMap;
    long contentLength = -1L;
    int statusCode = -1;
    int localPort = -1;
    ServerAdapter serverAdapter;
    private long timeStamp = 0L;

    public AccessEvent(HttpServletRequest httpRequest, HttpServletResponse httpResponse, ServerAdapter adapter) {
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.timeStamp = System.currentTimeMillis();
        this.serverAdapter = adapter;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        if (this.timeStamp != 0L) {
            throw new IllegalStateException("timeStamp has been already set for this event.");
        }
        this.timeStamp = timeStamp;
    }

    public String getRequestURI() {
        if (this.requestURI == null) {
            this.requestURI = this.httpRequest != null ? this.httpRequest.getRequestURI() : NA;
        }
        return this.requestURI;
    }

    public String getRequestURL() {
        if (this.requestURL == null) {
            if (this.httpRequest != null) {
                StringBuffer buf = new StringBuffer();
                buf.append(this.httpRequest.getMethod());
                buf.append(' ');
                buf.append(this.httpRequest.getRequestURI());
                String qStr = this.httpRequest.getQueryString();
                if (qStr != null) {
                    buf.append('?');
                    buf.append(qStr);
                }
                buf.append(' ');
                buf.append(this.httpRequest.getProtocol());
                this.requestURL = buf.toString();
            } else {
                this.requestURL = NA;
            }
        }
        return this.requestURL;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.remoteHost = this.httpRequest != null ? this.httpRequest.getRemoteHost() : NA;
        }
        return this.remoteHost;
    }

    public String getRemoteUser() {
        if (this.remoteUser == null) {
            this.remoteUser = this.httpRequest != null ? this.httpRequest.getRemoteUser() : NA;
        }
        return this.remoteUser;
    }

    public String getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.httpRequest != null ? this.httpRequest.getProtocol() : NA;
        }
        return this.protocol;
    }

    public String getMethod() {
        if (this.method == null) {
            this.method = this.httpRequest != null ? this.httpRequest.getMethod() : NA;
        }
        return this.method;
    }

    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = this.httpRequest != null ? this.httpRequest.getServerName() : NA;
        }
        return this.serverName;
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.remoteAddr = this.httpRequest != null ? this.httpRequest.getRemoteAddr() : NA;
        }
        return this.remoteAddr;
    }

    public String getRequestHeader(String key) {
        String result = null;
        if (this.requestHeaderMap == null) {
            if (this.httpRequest != null) {
                this.buildRequestHeaderMap();
                result = (String)this.requestHeaderMap.get(key);
            }
        } else {
            result = (String)this.requestHeaderMap.get(key);
        }
        if (result != null) {
            return result;
        }
        return NA;
    }

    public void buildRequestHeaderMap() {
        this.requestHeaderMap = new HashMap<String, Object>();
        Enumeration e = this.httpRequest.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.requestHeaderMap.put(key, this.httpRequest.getHeader(key));
        }
    }

    public String getResponseHeader(String key) {
        return this.serverAdapter.getResponseHeader(key);
    }

    public String getAttribute(String key) {
        if (this.httpRequest != null) {
            Object value = this.httpRequest.getAttribute(key);
            if (value == null) {
                return NA;
            }
            return value.toString();
        }
        return NA;
    }

    public String getRequestParameter(String key) {
        if (this.httpRequest != null) {
            String value = this.httpRequest.getParameter(key);
            if (value == null) {
                return NA;
            }
            return value.toString();
        }
        return NA;
    }

    public String getCookie(String key) {
        if (this.httpRequest != null) {
            Cookie[] cookieArray = this.httpRequest.getCookies();
            if (cookieArray == null) {
                return NA;
            }
            for (int i = 0; cookieArray != null && i < cookieArray.length; ++i) {
                if (!key.equals(cookieArray[i].getName())) continue;
                return cookieArray[i].getValue();
            }
        }
        return NA;
    }

    public long getContentLength() {
        if (this.contentLength == -1L && this.httpResponse != null) {
            this.contentLength = this.serverAdapter.getContentLength();
            return this.contentLength;
        }
        return this.contentLength;
    }

    public int getStatusCode() {
        if (this.statusCode == -1 && this.httpResponse != null) {
            this.statusCode = this.serverAdapter.getStatusCode();
        }
        return this.statusCode;
    }

    public String getPostContent() {
        if (this.postContent != null) {
            return this.postContent;
        }
        try {
            ServletInputStream in = this.httpRequest.getInputStream();
            this.postContent = Util.readToString((InputStream)in);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.postContent == null || this.postContent.length() == 0) {
            this.postContent = NA;
        }
        return this.postContent;
    }

    public int getLocalPort() {
        if (this.localPort == -1 && this.httpRequest != null) {
            this.localPort = this.httpRequest.getLocalPort();
        }
        return this.localPort;
    }

    public ServerAdapter getServerAdapter() {
        return this.serverAdapter;
    }
}

