/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.JettyServerAdapter;
import ch.qos.logback.access.jetty.RequestLogRegistry;
import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Response;

public class RequestLogImpl
extends ContextBase
implements RequestLog,
AppenderAttachable,
FilterAttachable {
    public static final String DEFAULT_CONFIG_FILE = "etc" + File.separatorChar + "logback-access.xml";
    AppenderAttachableImpl aai = new AppenderAttachableImpl();
    FilterAttachableImpl fai = new FilterAttachableImpl();
    String filename;
    boolean started = false;

    public RequestLogImpl() {
        this.putObject("EVALUATOR_MAP", new HashMap());
    }

    public void log(Request jettyRequest, Response jettyResponse) {
        JettyServerAdapter adapter = new JettyServerAdapter(jettyRequest, jettyResponse);
        AccessEvent accessEvent = new AccessEvent((HttpServletRequest)jettyRequest, (HttpServletResponse)jettyResponse, adapter);
        if (this.getFilterChainDecision(accessEvent) == FilterReply.DENY) {
            return;
        }
        this.aai.appendLoopOnAppenders((Object)accessEvent);
    }

    public void start() {
        if (this.filename == null) {
            String jettyHomeProperty = System.getProperty("jetty.home");
            this.filename = jettyHomeProperty + File.separatorChar + DEFAULT_CONFIG_FILE;
            this.getStatusManager().add((Status)new WarnStatus("filename property not set. Assuming [" + this.filename + "]", (Object)this));
        }
        try {
            File configFile = new File(this.filename);
            if (configFile.exists()) {
                JoranConfigurator jc = new JoranConfigurator();
                jc.setContext((Context)this);
                jc.doConfigure(this.filename);
            } else {
                this.getStatusManager().add((Status)new ErrorStatus("[" + this.filename + "] does not exist", (Object)this));
            }
            if (this.getName() == null) {
                this.setName("LogbackRequestLog");
            }
            RequestLogRegistry.register(this);
            this.getStatusManager().add((Status)new InfoStatus("RequestLog added to RequestLogRegistry with name: " + this.getName(), (Object)this));
            this.started = true;
        }
        catch (JoranException joranException) {
            // empty catch block
        }
    }

    public void stop() {
        this.aai.detachAndStopAllAppenders();
        this.started = false;
    }

    public boolean isRunning() {
        return this.started;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStarting() {
        return false;
    }

    public boolean isStopping() {
        return false;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public boolean isFailed() {
        return false;
    }

    public void addAppender(Appender newAppender) {
        this.aai.addAppender(newAppender);
    }

    public Iterator iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender appender) {
        return this.aai.detachAppender(appender);
    }

    public Appender detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    public void addFilter(Filter newFilter) {
        this.fai.addFilter(newFilter);
    }

    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    public FilterReply getFilterChainDecision(Object event) {
        return this.fai.getFilterChainDecision(event);
    }

    public Filter getFirstFilter() {
        return this.fai.getFirstFilter();
    }
}

