/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.JettyFixture;
import ch.qos.logback.access.jetty.RequestLogImpl;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.Util;
import ch.qos.logback.core.read.ListAppender;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JettyBasicTest {
    static RequestLogImpl requestLogImpl;
    static JettyFixture fixture;

    @BeforeClass
    public static void startServer() throws Exception {
        requestLogImpl = new RequestLogImpl();
        JettyFixture fixture = new JettyFixture(requestLogImpl);
        fixture.start();
    }

    @AfterClass
    public static void stopServer() throws Exception {
        if (fixture != null) {
            fixture.stop();
        }
    }

    @Test
    public void teztGetRequest() throws Exception {
        URL url = new URL("http://localhost:1234/");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        String result = Util.readToString((InputStream)connection.getInputStream());
        Assert.assertEquals((Object)"hello world", (Object)result);
        ListAppender appender = (ListAppender)requestLogImpl.getAppender("list");
        appender.list.clear();
    }

    @Test
    public void teztEventGoesToAppenders() throws Exception {
        URL url = new URL("http://localhost:1234/");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        String result = Util.readToString((InputStream)connection.getInputStream());
        Assert.assertEquals((Object)"hello world", (Object)result);
        ListAppender appender = (ListAppender)requestLogImpl.getAppender("list");
        Assert.assertTrue((appender.list.size() > 0 ? 1 : 0) != 0);
        AccessEvent event = (AccessEvent)appender.list.get(0);
        Assert.assertEquals((Object)"127.0.0.1", (Object)event.getRemoteHost());
        Assert.assertEquals((Object)"localhost", (Object)event.getServerName());
        appender.list.clear();
    }

    @Test
    public void teztPostContentConverter() throws Exception {
        URL url = new URL("http://localhost:1234/");
        String msg = "test message";
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setFixedLengthStreamingMode(msg.getBytes().length);
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "text/plain");
        PrintWriter output = new PrintWriter(new OutputStreamWriter(connection.getOutputStream()));
        output.print(msg);
        output.flush();
        output.close();
        ListAppender listAppender = (ListAppender)requestLogImpl.getAppender("list");
        Thread.sleep(100L);
        AccessEvent event = (AccessEvent)listAppender.list.get(0);
    }
}

