/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.pattern;

import ch.qos.logback.access.dummy.DummyRequest;
import ch.qos.logback.access.dummy.DummyResponse;
import ch.qos.logback.access.dummy.DummyServerAdapter;
import ch.qos.logback.access.pattern.ContentLengthConverter;
import ch.qos.logback.access.pattern.DateConverter;
import ch.qos.logback.access.pattern.LocalPortConverter;
import ch.qos.logback.access.pattern.RemoteHostConverter;
import ch.qos.logback.access.pattern.RemoteIPAddressConverter;
import ch.qos.logback.access.pattern.RemoteUserConverter;
import ch.qos.logback.access.pattern.RequestAttributeConverter;
import ch.qos.logback.access.pattern.RequestCookieConverter;
import ch.qos.logback.access.pattern.RequestHeaderConverter;
import ch.qos.logback.access.pattern.RequestMethodConverter;
import ch.qos.logback.access.pattern.RequestProtocolConverter;
import ch.qos.logback.access.pattern.RequestURIConverter;
import ch.qos.logback.access.pattern.RequestURLConverter;
import ch.qos.logback.access.pattern.ResponseHeaderConverter;
import ch.qos.logback.access.pattern.ServerNameConverter;
import ch.qos.logback.access.pattern.StatusCodeConverter;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import java.util.ArrayList;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;

public class ConverterTest
extends TestCase {
    AccessEvent event;
    DummyRequest request;
    DummyResponse response;

    public void setUp() throws Exception {
        super.setUp();
        this.request = new DummyRequest();
        this.response = new DummyResponse();
        this.event = this.createEvent();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.event = null;
        this.request = null;
        this.response = null;
    }

    public void testContentLengthConverter() {
        ContentLengthConverter converter = new ContentLengthConverter();
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((String)Long.toString(this.event.getServerAdapter().getContentLength()), (String)result);
    }

    public void testDateConverter() {
        DateConverter converter = new DateConverter();
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((String)converter.simpleFormat.format(this.event.getTimeStamp()), (String)result);
    }

    public void testLineLocalPortConverter() {
        LocalPortConverter converter = new LocalPortConverter();
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((String)Integer.toString(this.request.getLocalPort()), (String)result);
    }

    public void testRemoteHostConverter() {
        RemoteHostConverter converter = new RemoteHostConverter();
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((String)this.request.getRemoteHost(), (String)result);
    }

    public void testRemoteIPAddressConverter() {
        RemoteIPAddressConverter converter = new RemoteIPAddressConverter();
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((String)this.request.getRemoteAddr(), (String)result);
    }

    public void testRemoteUserConverter() {
        RemoteUserConverter converter = new RemoteUserConverter();
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((String)this.request.getRemoteUser(), (String)result);
    }

    public void testRequestAttributeConverter() {
        RequestAttributeConverter converter = new RequestAttributeConverter();
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("testKey");
        converter.setOptionList(optionList);
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((Object)this.request.getAttribute("testKey"), (Object)result);
    }

    public void testRequestCookieConverter() {
        RequestCookieConverter converter = new RequestCookieConverter();
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("testName");
        converter.setOptionList(optionList);
        converter.start();
        String result = converter.convert(this.event);
        Cookie cookie = this.request.getCookies()[0];
        ConverterTest.assertEquals((String)cookie.getValue(), (String)result);
    }

    public void testRequestHeaderConverter() {
        RequestHeaderConverter converter = new RequestHeaderConverter();
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("headerName1");
        converter.setOptionList(optionList);
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((String)this.request.getHeader("headerName1"), (String)result);
    }

    public void testRequestMethodConverter() {
        RequestMethodConverter converter = new RequestMethodConverter();
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((String)this.request.getMethod(), (String)result);
    }

    public void testRequestProtocolConverter() {
        RequestProtocolConverter converter = new RequestProtocolConverter();
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((String)this.request.getProtocol(), (String)result);
    }

    public void testRequestURIConverter() {
        RequestURIConverter converter = new RequestURIConverter();
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((String)this.request.getRequestURI(), (String)result);
    }

    public void testRequestURLConverter() {
        RequestURLConverter converter = new RequestURLConverter();
        converter.start();
        String result = converter.convert(this.event);
        String expected = this.request.getMethod() + " " + this.request.getRequestURI() + " " + this.request.getProtocol();
        ConverterTest.assertEquals((String)expected, (String)result);
    }

    public void testResponseHeaderConverter() {
        ResponseHeaderConverter converter = new ResponseHeaderConverter();
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("headerName1");
        converter.setOptionList(optionList);
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((String)this.request.getHeader("headerName1"), (String)result);
    }

    public void testServerNameConverter() {
        ServerNameConverter converter = new ServerNameConverter();
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((String)this.request.getServerName(), (String)result);
    }

    public void testStatusCodeConverter() {
        StatusCodeConverter converter = new StatusCodeConverter();
        converter.start();
        String result = converter.convert(this.event);
        ConverterTest.assertEquals((String)Integer.toString(this.event.getServerAdapter().getStatusCode()), (String)result);
    }

    private AccessEvent createEvent() {
        DummyServerAdapter dummyAdapter = new DummyServerAdapter(this.request, this.response);
        AccessEvent ae = new AccessEvent((HttpServletRequest)this.request, (HttpServletResponse)this.response, (ServerAdapter)dummyAdapter);
        return ae;
    }
}

