/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.PatternLayout;
import ch.qos.logback.access.jetty.BasicHandler;
import ch.qos.logback.access.jetty.RequestLogImpl;
import ch.qos.logback.access.testUtil.NotifyingListAppender;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;

public class JettyFixture {
    RequestLogImpl requestLogImpl;
    private final int port;
    Server server;
    String url;

    public JettyFixture(RequestLogImpl impl, int port) {
        this.requestLogImpl = impl;
        this.port = port;
        this.url = "http://localhost:" + port + "/";
    }

    public String getName() {
        return "Jetty Test Setup";
    }

    public String getUrl() {
        return this.url;
    }

    public void start() throws Exception {
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        this.server.setConnectors(new Connector[]{connector});
        ContextHandler context = new ContextHandler();
        context.setContextPath("/");
        context.setResourceBase(".");
        context.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.server.addHandler((Handler)context);
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        this.buildContext();
        requestLogHandler.setRequestLog((RequestLog)this.requestLogImpl);
        this.server.addHandler((Handler)requestLogHandler);
        BasicHandler handler = new BasicHandler();
        context.addHandler((Handler)handler);
        this.server.start();
        Thread.yield();
    }

    public void stop() throws Exception {
        this.server.stop();
        Thread.sleep(1000L);
        this.server = null;
        this.requestLogImpl = null;
    }

    private void buildContext() {
        NotifyingListAppender appender = new NotifyingListAppender();
        appender.setContext((Context)this.requestLogImpl);
        appender.setName("list");
        appender.start();
        ConsoleAppender console = new ConsoleAppender();
        console.setContext((Context)this.requestLogImpl);
        console.setName("console");
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)this.requestLogImpl);
        layout.setPattern("%date %server %clientHost");
        console.setLayout((Layout)layout);
        layout.start();
        console.start();
        this.requestLogImpl.addAppender((Appender)appender);
        this.requestLogImpl.addAppender((Appender)console);
    }
}

