/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.db;

import ch.qos.logback.access.db.DBAppender;
import ch.qos.logback.access.db.DBAppenderTestFixture;
import ch.qos.logback.access.dummy.DummyRequest;
import ch.qos.logback.access.dummy.DummyResponse;
import ch.qos.logback.access.dummy.DummyServerAdapter;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.db.ConnectionSource;
import ch.qos.logback.core.db.DriverManagerConnectionSource;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DBAppenderTest {
    AccessContext context;
    DBAppender appender;
    DriverManagerConnectionSource connectionSource;
    static DBAppenderTestFixture DB_APPENDER_TEST_FIXTURE;

    @BeforeClass
    public static void fixtureSetUp() throws SQLException {
        DB_APPENDER_TEST_FIXTURE = new DBAppenderTestFixture();
        DB_APPENDER_TEST_FIXTURE.setUp();
    }

    @AfterClass
    public static void fixtureTearDown() throws SQLException {
        DB_APPENDER_TEST_FIXTURE.tearDown();
    }

    @Before
    public void setUp() throws SQLException {
        this.context = new AccessContext();
        this.context.setName("default");
        this.appender = new DBAppender();
        this.appender.setName("DB");
        this.appender.setContext((Context)this.context);
        this.connectionSource = new DriverManagerConnectionSource();
        this.connectionSource.setContext((Context)this.context);
        this.connectionSource.setDriverClass("org.hsqldb.jdbcDriver");
        this.connectionSource.setUrl(DBAppenderTest.DB_APPENDER_TEST_FIXTURE.url);
        this.connectionSource.setUser(DBAppenderTest.DB_APPENDER_TEST_FIXTURE.user);
        this.connectionSource.setPassword(DBAppenderTest.DB_APPENDER_TEST_FIXTURE.password);
        this.connectionSource.start();
        this.appender.setConnectionSource((ConnectionSource)this.connectionSource);
    }

    private void setInsertHeadersAndStart(boolean insert) {
        this.appender.setInsertHeaders(insert);
        this.appender.start();
    }

    @After
    public void tearDown() throws SQLException {
        this.context = null;
        this.appender = null;
        this.connectionSource = null;
    }

    @Test
    public void testAppendAccessEvent() throws SQLException {
        this.setInsertHeadersAndStart(false);
        AccessEvent event = this.createAccessEvent();
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM access_event");
        if (rs.next()) {
            Assert.assertEquals((long)event.getTimeStamp(), (long)rs.getLong(1));
            Assert.assertEquals((Object)event.getRequestURI(), (Object)rs.getString(2));
            Assert.assertEquals((Object)event.getRequestURL(), (Object)rs.getString(3));
            Assert.assertEquals((Object)event.getRemoteHost(), (Object)rs.getString(4));
            Assert.assertEquals((Object)event.getRemoteUser(), (Object)rs.getString(5));
            Assert.assertEquals((Object)event.getRemoteAddr(), (Object)rs.getString(6));
            Assert.assertEquals((Object)event.getProtocol(), (Object)rs.getString(7));
            Assert.assertEquals((Object)event.getMethod(), (Object)rs.getString(8));
            Assert.assertEquals((Object)event.getServerName(), (Object)rs.getString(9));
            Assert.assertEquals((Object)event.getRequestContent(), (Object)rs.getString(10));
        } else {
            Assert.fail((String)"No row was inserted in the database");
        }
        rs.close();
        stmt.close();
    }

    @Test
    public void testCheckNoHeadersAreInserted() throws Exception {
        this.setInsertHeadersAndStart(false);
        AccessEvent event = this.createAccessEvent();
        this.appender.append((Object)event);
        StatusPrinter.print((StatusManager)this.context.getStatusManager());
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM access_event_header");
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
    }

    @Test
    public void testAppendHeaders() throws SQLException {
        this.setInsertHeadersAndStart(true);
        AccessEvent event = this.createAccessEvent();
        this.appender.append((Object)event);
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM access_event_header");
        if (!rs.next()) {
            Assert.fail((String)"There should be results to this query");
        } else {
            String key = rs.getString(2);
            String value = rs.getString(3);
            Assert.assertNotNull((Object)key);
            Assert.assertNotNull((Object)value);
            Assert.assertEquals((Object)event.getRequestHeader(key), (Object)value);
            rs.next();
            key = rs.getString(2);
            value = rs.getString(3);
            Assert.assertNotNull((Object)key);
            Assert.assertNotNull((Object)value);
            Assert.assertEquals((Object)event.getRequestHeader(key), (Object)value);
        }
        if (rs.next()) {
            Assert.fail((String)"There should be no more rows available");
        }
        rs.close();
        stmt.close();
    }

    @Test
    public void testAppendMultipleEvents() throws SQLException {
        String uri = "testAppendMultipleEvents";
        for (int i = 0; i < 10; ++i) {
            AccessEvent event = this.createAccessEvent(uri);
            this.appender.append((Object)event);
        }
        Statement stmt = this.connectionSource.getConnection().createStatement();
        ResultSet rs = null;
        rs = stmt.executeQuery("SELECT * FROM access_event where requestURI='" + uri + "'");
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((long)10L, (long)count);
        rs.close();
        stmt.close();
    }

    private AccessEvent createAccessEvent() {
        return this.createAccessEvent("");
    }

    private AccessEvent createAccessEvent(String uri) {
        DummyRequest request = new DummyRequest();
        request.setRequestUri(uri);
        DummyResponse response = new DummyResponse();
        DummyServerAdapter adapter = new DummyServerAdapter(request, response);
        AccessEvent ae = new AccessEvent((HttpServletRequest)request, (HttpServletResponse)response, (ServerAdapter)adapter);
        return ae;
    }
}

