/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.spi;

import ch.qos.logback.access.servlet.Util;
import ch.qos.logback.access.spi.ServerAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessEvent
implements Serializable {
    private static final long serialVersionUID = 866718993618836343L;
    public static final String NA = "-";
    public static final String[] NA_STRING_ARRAY = new String[]{"-"};
    public static final String EMPTY = "";
    public static final int SENTINEL = -1;
    private final transient HttpServletRequest httpRequest;
    private final transient HttpServletResponse httpResponse;
    String requestURI;
    String requestURL;
    String remoteHost;
    String remoteUser;
    String remoteAddr;
    String protocol;
    String method;
    String serverName;
    String requestContent;
    String responseContent;
    Map<String, String> requestHeaderMap;
    Map<String, String[]> requestParameterMap;
    Map<String, String> responseHeaderMap;
    long contentLength = -1L;
    int statusCode = -1;
    int localPort = -1;
    transient ServerAdapter serverAdapter;
    private long timeStamp = 0L;

    public AccessEvent(HttpServletRequest httpRequest, HttpServletResponse httpResponse, ServerAdapter adapter) {
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        this.timeStamp = System.currentTimeMillis();
        this.serverAdapter = adapter;
    }

    public HttpServletRequest getRequest() {
        return this.httpRequest;
    }

    public HttpServletResponse getResponse() {
        return this.httpResponse;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        if (this.timeStamp != 0L) {
            throw new IllegalStateException("timeStamp has been already set for this event.");
        }
        this.timeStamp = timeStamp;
    }

    public String getRequestURI() {
        if (this.requestURI == null) {
            this.requestURI = this.httpRequest != null ? this.httpRequest.getRequestURI() : NA;
        }
        return this.requestURI;
    }

    public String getRequestURL() {
        if (this.requestURL == null) {
            if (this.httpRequest != null) {
                StringBuffer buf = new StringBuffer();
                buf.append(this.httpRequest.getMethod());
                buf.append(' ');
                buf.append(this.httpRequest.getRequestURI());
                String qStr = this.httpRequest.getQueryString();
                if (qStr != null) {
                    buf.append('?');
                    buf.append(qStr);
                }
                buf.append(' ');
                buf.append(this.httpRequest.getProtocol());
                this.requestURL = buf.toString();
            } else {
                this.requestURL = NA;
            }
        }
        return this.requestURL;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.remoteHost = this.httpRequest != null ? this.httpRequest.getRemoteHost() : NA;
        }
        return this.remoteHost;
    }

    public String getRemoteUser() {
        if (this.remoteUser == null) {
            this.remoteUser = this.httpRequest != null ? this.httpRequest.getRemoteUser() : NA;
        }
        return this.remoteUser;
    }

    public String getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.httpRequest != null ? this.httpRequest.getProtocol() : NA;
        }
        return this.protocol;
    }

    public String getMethod() {
        if (this.method == null) {
            this.method = this.httpRequest != null ? this.httpRequest.getMethod() : NA;
        }
        return this.method;
    }

    public String getServerName() {
        if (this.serverName == null) {
            this.serverName = this.httpRequest != null ? this.httpRequest.getServerName() : NA;
        }
        return this.serverName;
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.remoteAddr = this.httpRequest != null ? this.httpRequest.getRemoteAddr() : NA;
        }
        return this.remoteAddr;
    }

    public String getRequestHeader(String key) {
        String result = null;
        if (this.requestHeaderMap == null) {
            if (this.httpRequest != null) {
                this.buildRequestHeaderMap();
                result = this.requestHeaderMap.get(key);
            }
        } else {
            result = this.requestHeaderMap.get(key);
        }
        if (result != null) {
            return result;
        }
        return NA;
    }

    public Enumeration getRequestHeaderNames() {
        if (this.httpRequest == null) {
            Vector<String> list = new Vector<String>(this.getRequestHeaderMap().keySet());
            return list.elements();
        }
        return this.httpRequest.getHeaderNames();
    }

    public Map<String, String> getRequestHeaderMap() {
        if (this.requestHeaderMap == null) {
            this.buildRequestHeaderMap();
        }
        return this.requestHeaderMap;
    }

    public void buildRequestHeaderMap() {
        this.requestHeaderMap = new HashMap<String, String>();
        Enumeration e = this.httpRequest.getHeaderNames();
        if (e == null) {
            return;
        }
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.requestHeaderMap.put(key, this.httpRequest.getHeader(key));
        }
    }

    public void buildRequestParameterMap() {
        this.requestParameterMap = new HashMap<String, String[]>();
        Enumeration e = this.httpRequest.getParameterNames();
        if (e == null) {
            return;
        }
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.requestParameterMap.put(key, this.httpRequest.getParameterValues(key));
        }
    }

    public Map<String, String[]> getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.buildRequestParameterMap();
        }
        return this.requestParameterMap;
    }

    public String getAttribute(String key) {
        if (this.httpRequest != null) {
            Object value = this.httpRequest.getAttribute(key);
            if (value == null) {
                return NA;
            }
            return value.toString();
        }
        return NA;
    }

    public String[] getRequestParameter(String key) {
        if (this.httpRequest != null) {
            String[] value = this.httpRequest.getParameterValues(key);
            if (value == null) {
                return NA_STRING_ARRAY;
            }
            return value;
        }
        return NA_STRING_ARRAY;
    }

    public String getCookie(String key) {
        if (this.httpRequest != null) {
            Cookie[] cookieArray = this.httpRequest.getCookies();
            if (cookieArray == null) {
                return NA;
            }
            for (Cookie cookie : cookieArray) {
                if (!key.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return NA;
    }

    public long getContentLength() {
        if (this.contentLength == -1L && this.httpResponse != null) {
            this.contentLength = this.serverAdapter.getContentLength();
            return this.contentLength;
        }
        return this.contentLength;
    }

    public int getStatusCode() {
        if (this.statusCode == -1 && this.httpResponse != null) {
            this.statusCode = this.serverAdapter.getStatusCode();
        }
        return this.statusCode;
    }

    public String getRequestContent() {
        if (this.requestContent != null) {
            return this.requestContent;
        }
        if (Util.isFormUrlEncoded(this.httpRequest)) {
            StringBuffer buf = new StringBuffer();
            Enumeration pramEnumeration = this.httpRequest.getParameterNames();
            int count = 0;
            try {
                while (pramEnumeration.hasMoreElements()) {
                    String key = (String)pramEnumeration.nextElement();
                    if (count++ != 0) {
                        buf.append("&");
                    }
                    buf.append(key);
                    buf.append("=");
                    String val = this.httpRequest.getParameter(key);
                    if (val != null) {
                        buf.append(val);
                        continue;
                    }
                    buf.append(EMPTY);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.requestContent = buf.toString();
        } else {
            byte[] inputBuffer = (byte[])this.httpRequest.getAttribute("LB_INPUT_BUFFER");
            if (inputBuffer != null) {
                this.requestContent = new String(inputBuffer);
            }
            if (this.requestContent == null || this.requestContent.length() == 0) {
                this.requestContent = EMPTY;
            }
        }
        return this.requestContent;
    }

    public String getResponseContent() {
        if (this.responseContent != null) {
            return this.responseContent;
        }
        if (Util.isImageResponse(this.httpResponse)) {
            this.responseContent = "[IMAGE CONTENTS SUPPRESSED]";
        } else {
            byte[] outputBuffer = (byte[])this.httpRequest.getAttribute("LB_OUTPUT_BUFFER");
            if (outputBuffer != null) {
                this.responseContent = new String(outputBuffer);
            }
            if (this.responseContent == null || this.responseContent.length() == 0) {
                this.responseContent = EMPTY;
            }
        }
        return this.responseContent;
    }

    public int getLocalPort() {
        if (this.localPort == -1 && this.httpRequest != null) {
            this.localPort = this.httpRequest.getLocalPort();
        }
        return this.localPort;
    }

    public ServerAdapter getServerAdapter() {
        return this.serverAdapter;
    }

    public String getResponseHeader(String key) {
        this.buildResponseHeaderMap();
        return this.responseHeaderMap.get(key);
    }

    void buildResponseHeaderMap() {
        if (this.responseHeaderMap == null) {
            this.responseHeaderMap = this.serverAdapter.buildResponseHeaderMap();
        }
    }

    public Map<String, String> getResponseHeaderMap() {
        this.buildResponseHeaderMap();
        return this.responseHeaderMap;
    }

    public List<String> getResponseHeaderNameList() {
        this.buildResponseHeaderMap();
        return new ArrayList<String>(this.responseHeaderMap.keySet());
    }

    public void prepareForDeferredProcessing() {
        this.buildRequestHeaderMap();
        this.buildRequestParameterMap();
        this.buildResponseHeaderMap();
        this.getLocalPort();
        this.getMethod();
        this.getProtocol();
        this.getRemoteAddr();
        this.getRemoteHost();
        this.getRemoteUser();
        this.getRequestURI();
        this.getRequestURL();
        this.getServerName();
        this.getTimeStamp();
        this.getStatusCode();
        this.getContentLength();
        this.getRequestContent();
        this.getResponseContent();
    }
}

