/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.net;

import ch.qos.logback.access.dummy.DummyRequest;
import ch.qos.logback.access.dummy.DummyResponse;
import ch.qos.logback.access.dummy.DummyServerAdapter;
import ch.qos.logback.access.net.MockSocketServer;
import ch.qos.logback.access.net.SocketAppender;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;

public class SocketAppenderTest {
    private AccessContext context;
    private MockSocketServer mockSocketServer;

    @Test
    public void testStartFailNoRemoteHost() {
        this.context = new AccessContext();
        SocketAppender appender = new SocketAppender();
        appender.setContext((Context)this.context);
        appender.setPort(123);
        appender.start();
        Assert.assertEquals((long)1L, (long)this.context.getStatusManager().getCount());
    }

    @Test
    public void testRecieveMessage() throws InterruptedException {
        this.startServer(1);
        this.configureClient();
        this.context.callAppenders(this.buildNewAccessEvent());
        this.mockSocketServer.join(2000L);
        Assert.assertTrue((boolean)this.mockSocketServer.finished);
        Assert.assertEquals((long)1L, (long)this.mockSocketServer.accessEventList.size());
        AccessEvent remoteEvent = this.mockSocketServer.accessEventList.get(0);
        Assert.assertEquals((Object)"headerValue1", (Object)remoteEvent.getRequestHeader("headerName1"));
        Assert.assertEquals((Object)"testHost", (Object)remoteEvent.getRemoteHost());
    }

    private void startServer(int expectedEventNumber) throws InterruptedException {
        this.mockSocketServer = new MockSocketServer(expectedEventNumber);
        this.mockSocketServer.start();
        Thread.sleep(100L);
    }

    private void configureClient() {
        this.context = new AccessContext();
        this.context.setName("test");
        SocketAppender socketAppender = new SocketAppender();
        socketAppender.setContext((Context)this.context);
        socketAppender.setName("socket");
        socketAppender.setPort(4560);
        socketAppender.setRemoteHost("localhost");
        this.context.addAppender((Appender)socketAppender);
        socketAppender.start();
    }

    private AccessEvent buildNewAccessEvent() {
        DummyRequest request = new DummyRequest();
        DummyResponse response = new DummyResponse();
        DummyServerAdapter adapter = new DummyServerAdapter(request, response);
        AccessEvent ae = new AccessEvent((HttpServletRequest)request, (HttpServletResponse)response, (ServerAdapter)adapter);
        return ae;
    }
}

