/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.db;

import ch.qos.logback.access.dummy.DummyAccessEventBuilder;
import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.testUtil.Env;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.Random;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class DBAppenderIntegrationTest {
    static String LOCAL_HOST_NAME = Env.getLocalHostName();
    static String[] CONFORMING_HOST_LIST = new String[]{"Orion"};
    int diff = new Random(System.nanoTime()).nextInt(10000);
    AccessContext context = new AccessContext();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    public void doTest(String configFile) throws JoranException {
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)this.context);
        configurator.doConfigure(configFile);
        Appender appender = this.context.getAppender("DB");
        for (int i = 0; i < 10; ++i) {
            AccessEvent event = DummyAccessEventBuilder.buildNewAccessEvent();
            appender.doAppend((Object)event);
        }
        StatusPrinter.print((Context)this.context);
        Assert.assertEquals((long)0L, (long)this.context.getStatusManager().getLevel());
    }

    static boolean isConformingHostAndJDK16OrHigher() {
        if (!Env.isJDK6OrHigher()) {
            return false;
        }
        return Env.isLocalHostNameInList((String[])CONFORMING_HOST_LIST);
    }

    @Test
    public void sqlserver() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher()) {
            return;
        }
        this.doTest("src/test/input/integration/db/sqlserver-with-driver.xml");
    }

    @Test
    @Ignore
    public void oracle10g() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher()) {
            return;
        }
        this.doTest("src/test/input/integration/db/oracle10g-with-driver.xml");
    }

    @Test
    @Ignore
    public void oracle11g() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher()) {
            return;
        }
        this.doTest("src/test/input/integration/db/oracle11g-with-driver.xml");
    }

    @Test
    public void mysql() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher()) {
            return;
        }
        this.doTest("src/test/input/integration/db/mysql-with-driver.xml");
    }

    @Test
    public void postgres() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher()) {
            return;
        }
        this.doTest("src/test/input/integration/db/postgresql-with-driver.xml");
    }
}

