/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.RequestLogImpl;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;

public abstract class JettyFixtureBase {
    protected RequestLogImpl requestLogImpl;
    private final int port;
    Server server;
    String url;

    public JettyFixtureBase(RequestLogImpl impl, int port) {
        this.requestLogImpl = impl;
        this.port = port;
        this.url = "http://localhost:" + port + "/";
    }

    public String getName() {
        return "Jetty Test Setup";
    }

    public String getUrl() {
        return this.url;
    }

    public void start() throws Exception {
        this.server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        this.server.setConnectors(new Connector[]{connector});
        ContextHandler context = new ContextHandler();
        context.setContextPath("/");
        context.setResourceBase(".");
        context.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.server.addHandler((Handler)context);
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        this.buildContext();
        requestLogHandler.setRequestLog((RequestLog)this.requestLogImpl);
        this.server.addHandler((Handler)requestLogHandler);
        Handler handler = this.getHandler();
        context.addHandler(handler);
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.server = null;
        this.requestLogImpl = null;
    }

    protected abstract void buildContext();

    protected abstract Handler getHandler();
}

