/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.JettyTestSetup;
import ch.qos.logback.access.jetty.RequestLogImpl;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.Util;
import ch.qos.logback.core.read.ListAppender;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class JettyBasicTest
extends TestCase {
    static RequestLogImpl requestLogImpl;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(JettyBasicTest.class);
        requestLogImpl = new RequestLogImpl();
        return new JettyTestSetup((Test)suite, requestLogImpl);
    }

    public void testGetRequest() throws Exception {
        URL url = new URL("http://localhost:1234/");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        String result = Util.readToString((InputStream)connection.getInputStream());
        JettyBasicTest.assertEquals((String)"hello world", (String)result);
        ListAppender appender = (ListAppender)requestLogImpl.getAppender("list");
        appender.list.clear();
    }

    public void testEventGoesToAppenders() throws Exception {
        URL url = new URL("http://localhost:1234/");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        String result = Util.readToString((InputStream)connection.getInputStream());
        JettyBasicTest.assertEquals((String)"hello world", (String)result);
        ListAppender appender = (ListAppender)requestLogImpl.getAppender("list");
        AccessEvent event = (AccessEvent)appender.list.get(0);
        JettyBasicTest.assertEquals((String)"127.0.0.1", (String)event.getRemoteHost());
        JettyBasicTest.assertEquals((String)"localhost", (String)event.getServerName());
        appender.list.clear();
    }
}

