/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;

public class TeeServletOutputStream
extends ServletOutputStream {
    final ServletOutputStream underlyingStream;
    final ByteArrayOutputStream baos;

    TeeServletOutputStream(ServletResponse httpServletResponse) throws IOException {
        this.underlyingStream = httpServletResponse.getOutputStream();
        this.baos = new ByteArrayOutputStream();
    }

    byte[] getOutputBuffer() {
        return this.baos.toByteArray();
    }

    public void write(int val) throws IOException {
        this.underlyingStream.write(val);
        this.baos.write(val);
    }

    public void write(byte[] byteArray) throws IOException {
        this.write(byteArray, 0, byteArray.length);
    }

    public void write(byte[] byteArray, int offset, int length) throws IOException {
        this.underlyingStream.write(byteArray, offset, length);
        this.baos.write(byteArray, offset, length);
    }

    public void close() throws IOException {
    }

    public void finish() throws IOException {
        this.flush();
        this.underlyingStream.close();
        this.baos.close();
    }

    public void flush() throws IOException {
        this.underlyingStream.flush();
        this.baos.flush();
    }
}

