/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.spi;

import ch.qos.logback.access.dummy.DummyAccessEventBuilder;
import ch.qos.logback.access.dummy.DummyRequest;
import ch.qos.logback.access.dummy.DummyResponse;
import ch.qos.logback.access.dummy.DummyServerAdapter;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;

public class AccessEventSerializationTest {
    private Object buildSerializedAccessEvent() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        IAccessEvent ae = DummyAccessEventBuilder.buildNewAccessEvent();
        ae.prepareForDeferredProcessing();
        oos.writeObject(ae);
        oos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        Object o = this.buildSerializedAccessEvent();
        Assert.assertNotNull((Object)o);
        IAccessEvent aeBack = (IAccessEvent)o;
        Assert.assertEquals(DummyResponse.DUMMY_DEFAULT_HDEADER_MAP, (Object)aeBack.getResponseHeaderMap());
        Assert.assertEquals((Object)DummyResponse.DUMMY_DEFAULT_HDEADER_MAP.get("x"), (Object)aeBack.getResponseHeader("x"));
        Assert.assertEquals((Object)DummyResponse.DUMMY_DEFAULT_HDEADER_MAP.get("headerName1"), (Object)aeBack.getResponseHeader("headerName1"));
        Assert.assertEquals((long)DummyResponse.DUMMY_DEFAULT_HDEADER_MAP.size(), (long)aeBack.getResponseHeaderNameList().size());
        Assert.assertEquals((long)1000L, (long)aeBack.getContentLength());
        Assert.assertEquals((long)200L, (long)aeBack.getStatusCode());
        Assert.assertEquals((Object)"request contents", (Object)aeBack.getRequestContent());
        Assert.assertEquals((Object)"response contents", (Object)aeBack.getResponseContent());
        Assert.assertEquals((Object)DummyRequest.DUMMY_DEFAULT_ATTR_MAP.get("testKey"), (Object)aeBack.getAttribute("testKey"));
    }

    @Test
    public void testAttributesAreNotTakenFromRecycledRequestWhenProcessingDeferred() {
        DummyRequest request = new DummyRequest();
        DummyResponse response = new DummyResponse();
        DummyServerAdapter adapter = new DummyServerAdapter(request, response);
        AccessEvent event = new AccessEvent((HttpServletRequest)request, (HttpServletResponse)response, (ServerAdapter)adapter);
        request.setAttribute("testKey", "ORIGINAL");
        event.prepareForDeferredProcessing();
        request.setAttribute("testKey", "NEW");
        Assert.assertEquals((Object)"ORIGINAL", (Object)event.getAttribute("testKey"));
    }
}

