/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.spi;

import ch.qos.logback.access.dummy.DummyAccessEventBuilder;
import ch.qos.logback.access.dummy.DummyRequest;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AccessEventTest {
    int diff = RandomUtil.getPositiveInt();

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void callingPrepareForDeferredProcessingShouldBeIdempotent() {
        String key = "key-" + this.diff;
        String val = "val-" + this.diff;
        IAccessEvent ae = DummyAccessEventBuilder.buildNewAccessEvent();
        DummyRequest request = (DummyRequest)ae.getRequest();
        Map<String, String> headersMap = request.getHeaders();
        Map<String, String[]> parametersMap = request.getParameterMap();
        headersMap.put(key, val);
        request.setAttribute(key, val);
        parametersMap.put(key, new String[]{val});
        ae.prepareForDeferredProcessing();
        Assert.assertEquals((Object)val, (Object)ae.getAttribute(key));
        Assert.assertEquals((Object)val, (Object)ae.getRequestHeader(key));
        Assert.assertEquals((Object)val, (Object)ae.getRequestParameter(key)[0]);
        request.setAttribute(key, "change");
        headersMap.put(key, "change");
        parametersMap.put(key, new String[]{"change"});
        ae.prepareForDeferredProcessing();
        Assert.assertEquals((Object)val, (Object)ae.getAttribute(key));
        Assert.assertEquals((Object)val, (Object)ae.getRequestHeader(key));
        Assert.assertEquals((Object)val, (Object)ae.getRequestParameter(key)[0]);
    }
}

