/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.joran;

import ch.qos.logback.access.joran.JoranConfigurator;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.testUtil.StatusChecker;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConditionalTest {
    AccessContext context = new AccessContext();
    StatusChecker checker = new StatusChecker((Context)this.context);
    int diff = RandomUtil.getPositiveInt();
    String randomOutputDir = "target/test-output/" + this.diff + "/";

    @Before
    public void setUp() {
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
            this.context.putProperty("aHost", localhost.getHostName());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.context);
        jc.doConfigure(file);
    }

    @Test
    public void conditionalConsoleApp_IF_THEN_True() throws JoranException, UnknownHostException {
        this.configure("src/test/input/joran/conditional/conditionalConsole.xml");
        ConsoleAppender consoleAppender = (ConsoleAppender)this.context.getAppender("CON");
        Assert.assertNotNull((Object)consoleAppender);
        Assert.assertTrue((boolean)this.checker.isErrorFree(0L));
    }

    @Test
    public void conditionalConsoleApp_IF_THEN_False() throws JoranException, IOException, InterruptedException {
        this.context.putProperty("aHost", null);
        this.configure("src/test/input/joran/conditional/conditionalConsole.xml");
        ConsoleAppender consoleAppender = (ConsoleAppender)this.context.getAppender("CON");
        Assert.assertNull((Object)consoleAppender);
        StatusChecker checker = new StatusChecker((Context)this.context);
        Assert.assertTrue((boolean)checker.isErrorFree(0L));
    }

    @Test
    public void conditionalConsoleApp_ELSE() throws JoranException, IOException, InterruptedException {
        this.configure("src/test/input/joran/conditional/conditionalConsole_ELSE.xml");
        ConsoleAppender consoleAppender = (ConsoleAppender)this.context.getAppender("CON");
        Assert.assertNull((Object)consoleAppender);
        ListAppender listAppender = (ListAppender)this.context.getAppender("LIST");
        Assert.assertNotNull((Object)listAppender);
        Assert.assertTrue((boolean)this.checker.isErrorFree(0L));
    }
}

