/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.servlet;

import ch.qos.logback.access.servlet.TeeFilter;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class TeeFilterTest {
    @Test
    public void extractNameList() {
        Assert.assertEquals(Arrays.asList("a"), (Object)TeeFilter.extractNameList((String)"a"));
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)TeeFilter.extractNameList((String)"a, b"));
        Assert.assertEquals(Arrays.asList("a", "b"), (Object)TeeFilter.extractNameList((String)"a; b"));
        Assert.assertEquals(Arrays.asList("a", "b", "c"), (Object)TeeFilter.extractNameList((String)"a; b, c"));
    }

    @Test
    public void defaultCase() {
        Assert.assertTrue((boolean)TeeFilter.computeActivation((String)"somehost", (String)"", (String)""));
        Assert.assertTrue((boolean)TeeFilter.computeActivation((String)"somehost", null, null));
    }

    @Test
    public void withIncludesOnly() {
        Assert.assertTrue((boolean)TeeFilter.computeActivation((String)"a", (String)"a", null));
        Assert.assertTrue((boolean)TeeFilter.computeActivation((String)"a", (String)"a, b", null));
        Assert.assertFalse((boolean)TeeFilter.computeActivation((String)"a", (String)"b", null));
        Assert.assertFalse((boolean)TeeFilter.computeActivation((String)"a", (String)"b, c", null));
    }

    @Test
    public void withExcludesOnly() {
        Assert.assertFalse((boolean)TeeFilter.computeActivation((String)"a", null, (String)"a"));
        Assert.assertFalse((boolean)TeeFilter.computeActivation((String)"a", null, (String)"a, b"));
        Assert.assertTrue((boolean)TeeFilter.computeActivation((String)"a", null, (String)"b"));
        Assert.assertTrue((boolean)TeeFilter.computeActivation((String)"a", null, (String)"b, c"));
    }

    @Test
    public void withIncludesAndExcludes() {
        Assert.assertFalse((boolean)TeeFilter.computeActivation((String)"a", (String)"a", (String)"a"));
        Assert.assertTrue((boolean)TeeFilter.computeActivation((String)"a", (String)"a", (String)"b"));
        Assert.assertFalse((boolean)TeeFilter.computeActivation((String)"a", (String)"b", (String)"a"));
        Assert.assertFalse((boolean)TeeFilter.computeActivation((String)"a", (String)"b", (String)"b"));
    }
}

