/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.jetty;

import ch.qos.logback.access.jetty.RequestLogImpl;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;

public class JettyFixtureBase {
    protected final RequestLogImpl requestLogImpl;
    protected Handler handler = new BasicHandler();
    private final int port;
    Server server;
    protected String url;

    public JettyFixtureBase(RequestLogImpl impl, int port) {
        this.requestLogImpl = impl;
        this.port = port;
        this.url = "http://localhost:" + port + "/";
    }

    public String getName() {
        return "Jetty Test Setup";
    }

    public String getUrl() {
        return this.url;
    }

    public void start() throws Exception {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(this.port);
        this.server.setConnectors(new Connector[]{connector});
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        this.configureRequestLogImpl();
        requestLogHandler.setRequestLog((RequestLog)this.requestLogImpl);
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)requestLogHandler);
        handlers.addHandler(this.getRequestHandler());
        this.server.setHandler((Handler)handlers);
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.server = null;
    }

    protected void configureRequestLogImpl() {
        this.requestLogImpl.start();
    }

    protected Handler getRequestHandler() {
        return this.handler;
    }

    class BasicHandler
    extends AbstractHandler {
        BasicHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ServletOutputStream out = response.getOutputStream();
            ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer();
            writer.write("hello world");
            writer.flush();
            response.setContentLength(writer.size());
            writer.writeTo((OutputStream)out);
            out.flush();
            baseRequest.setHandled(true);
        }
    }
}

