/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.servlet;

import ch.qos.logback.access.dummy.DummyResponse;
import ch.qos.logback.access.dummy.DummyServletOutputStream;
import ch.qos.logback.access.servlet.TeeHttpServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TeeHttpServletResponseTest {
    String characterEncoding;
    String testString;
    byte[] expectedBytes;

    public TeeHttpServletResponseTest(String characterEncoding, String testString, byte[] expectedBytes) {
        this.characterEncoding = characterEncoding;
        this.testString = testString;
        this.expectedBytes = expectedBytes;
    }

    @Parameterized.Parameters
    public static Collection<?> inputValues() {
        return Arrays.asList({"utf-8", "G\u00fclc\u00fc", new byte[]{71, -61, -68, 108, 99, -61, -68}}, {"iso-8859-1", "G\u00fclc\u00fc", new byte[]{71, -4, 108, 99, -4}});
    }

    @Test
    public void testWriterEncoding() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DummyResponse dummyResponse = new DummyResponse();
        dummyResponse.setCharacterEncoding(this.characterEncoding);
        dummyResponse.setOutputStream(new DummyServletOutputStream(byteArrayOutputStream));
        TeeHttpServletResponse teeServletResponse = new TeeHttpServletResponse((HttpServletResponse)dummyResponse);
        PrintWriter writer = teeServletResponse.getWriter();
        writer.write(this.testString);
        writer.flush();
        Assert.assertArrayEquals((byte[])this.expectedBytes, (byte[])byteArrayOutputStream.toByteArray());
    }
}

