/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.net;

import ch.qos.logback.access.dummy.DummyAccessEventBuilder;
import ch.qos.logback.access.net.NOPOutputStream;
import ch.qos.logback.access.spi.IAccessEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled
public class SerializationPerfTest {
    ObjectOutputStream oos;
    int loopNumber = 10000;
    int resetFrequency = 100;
    int pauseFrequency = 10;
    long pauseLengthInMillis = 20L;

    @BeforeEach
    public void setUp() throws Exception {
        this.oos = new ObjectOutputStream(new NOPOutputStream());
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.oos.close();
        this.oos = null;
    }

    @Test
    public void test1() throws Exception {
        int resetCounter = 0;
        int pauseCounter = 0;
        for (int i = 0; i < this.loopNumber; ++i) {
            try {
                IAccessEvent ae = DummyAccessEventBuilder.buildNewAccessEvent();
                ae.prepareForDeferredProcessing();
                this.oos.writeObject(ae);
                this.oos.flush();
                if (++resetCounter >= this.resetFrequency) {
                    this.oos.reset();
                    resetCounter = 0;
                }
                if (++pauseCounter < this.pauseFrequency) continue;
                Thread.sleep(this.pauseLengthInMillis);
                pauseCounter = 0;
                continue;
            }
            catch (IOException ex) {
                Assertions.fail((String)ex.getMessage());
            }
        }
        Long total = 0L;
        resetCounter = 0;
        pauseCounter = 0;
        for (int i = 0; i < this.loopNumber; ++i) {
            try {
                IAccessEvent ae = DummyAccessEventBuilder.buildNewAccessEvent();
                Long t1 = System.nanoTime();
                ae.prepareForDeferredProcessing();
                this.oos.writeObject(ae);
                this.oos.flush();
                Long t2 = System.nanoTime();
                total = total + (t2 - t1);
                if (++resetCounter >= this.resetFrequency) {
                    this.oos.reset();
                    resetCounter = 0;
                }
                if (++pauseCounter < this.pauseFrequency) continue;
                Thread.sleep(this.pauseLengthInMillis);
                pauseCounter = 0;
                continue;
            }
            catch (IOException ex) {
                Assertions.fail((String)ex.getMessage());
            }
        }
        total = total / 1000L;
        System.out.println("Loop done : average time = " + total / (long)this.loopNumber + " microsecs after " + this.loopNumber + " writes.");
    }
}

