/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.spi;

import ch.qos.logback.access.dummy.DummyAccessEventBuilder;
import ch.qos.logback.access.dummy.DummyRequest;
import ch.qos.logback.access.dummy.DummyResponse;
import ch.qos.logback.access.dummy.DummyServerAdapter;
import ch.qos.logback.access.net.HardenedAccessEventInputStream;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import ch.qos.logback.core.Context;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AccessEventSerializationTest {
    private Object buildSerializedAccessEvent() throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        IAccessEvent ae = DummyAccessEventBuilder.buildNewAccessEvent();
        ae.prepareForDeferredProcessing();
        oos.writeObject(ae);
        oos.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        HardenedAccessEventInputStream hardenedOIS = new HardenedAccessEventInputStream((InputStream)bais);
        Object sae = hardenedOIS.readObject();
        hardenedOIS.close();
        return sae;
    }

    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        Object o = this.buildSerializedAccessEvent();
        Assertions.assertNotNull((Object)o);
        IAccessEvent aeBack = (IAccessEvent)o;
        Assertions.assertEquals(DummyResponse.DUMMY_DEFAULT_HDEADER_MAP, (Object)aeBack.getResponseHeaderMap());
        Assertions.assertEquals((Object)DummyResponse.DUMMY_DEFAULT_HDEADER_MAP.get("x"), (Object)aeBack.getResponseHeader("x"));
        Assertions.assertEquals((Object)DummyResponse.DUMMY_DEFAULT_HDEADER_MAP.get("headerName1"), (Object)aeBack.getResponseHeader("headerName1"));
        Assertions.assertEquals((int)DummyResponse.DUMMY_DEFAULT_HDEADER_MAP.size(), (int)aeBack.getResponseHeaderNameList().size());
        Assertions.assertEquals((long)1000L, (long)aeBack.getContentLength());
        Assertions.assertEquals((int)200, (int)aeBack.getStatusCode());
        Assertions.assertEquals((Object)"request contents", (Object)aeBack.getRequestContent());
        Assertions.assertEquals((Object)"response contents", (Object)aeBack.getResponseContent());
        Assertions.assertEquals((Object)DummyRequest.DUMMY_DEFAULT_ATTR_MAP.get("testKey"), (Object)aeBack.getAttribute("testKey"));
    }

    @Test
    public void testAttributesAreNotTakenFromRecycledRequestWhenProcessingDeferred() {
        DummyRequest request = new DummyRequest();
        DummyResponse response = new DummyResponse();
        DummyServerAdapter adapter = new DummyServerAdapter(request, response);
        AccessContext accessContext = new AccessContext();
        AccessEvent event = new AccessEvent((Context)accessContext, (HttpServletRequest)request, (HttpServletResponse)response, (ServerAdapter)adapter);
        request.setAttribute("testKey", "ORIGINAL");
        event.prepareForDeferredProcessing();
        request.setAttribute("testKey", "NEW");
        Assertions.assertEquals((Object)"ORIGINAL", (Object)event.getAttribute("testKey"));
    }
}

