/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.pattern;

import ch.qos.logback.access.dummy.DummyRequest;
import ch.qos.logback.access.dummy.DummyResponse;
import ch.qos.logback.access.dummy.DummyServerAdapter;
import ch.qos.logback.access.pattern.ContentLengthConverter;
import ch.qos.logback.access.pattern.DateConverter;
import ch.qos.logback.access.pattern.LocalPortConverter;
import ch.qos.logback.access.pattern.RemoteHostConverter;
import ch.qos.logback.access.pattern.RemoteIPAddressConverter;
import ch.qos.logback.access.pattern.RemoteUserConverter;
import ch.qos.logback.access.pattern.RequestAttributeConverter;
import ch.qos.logback.access.pattern.RequestCookieConverter;
import ch.qos.logback.access.pattern.RequestHeaderConverter;
import ch.qos.logback.access.pattern.RequestMethodConverter;
import ch.qos.logback.access.pattern.RequestProtocolConverter;
import ch.qos.logback.access.pattern.RequestURIConverter;
import ch.qos.logback.access.pattern.RequestURLConverter;
import ch.qos.logback.access.pattern.ResponseHeaderConverter;
import ch.qos.logback.access.pattern.ServerNameConverter;
import ch.qos.logback.access.pattern.StatusCodeConverter;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import ch.qos.logback.core.Context;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConverterTest {
    IAccessEvent event;
    DummyRequest request = new DummyRequest();
    DummyResponse response = new DummyResponse();
    AccessContext accessContext = new AccessContext();

    @BeforeEach
    public void setUp() throws Exception {
        this.event = this.createEvent();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.event = null;
        this.request = null;
        this.response = null;
    }

    @Test
    public void testContentLengthConverter() {
        ContentLengthConverter converter = new ContentLengthConverter();
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)Long.toString(this.event.getServerAdapter().getContentLength()), (Object)result);
    }

    @Test
    public void testDateConverter() {
        DateConverter converter = new DateConverter();
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)converter.cachingDateFormatter.format(this.event.getTimeStamp()), (Object)result);
    }

    public void testLineLocalPortConverter() {
        LocalPortConverter converter = new LocalPortConverter();
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)Integer.toString(this.request.getLocalPort()), (Object)result);
    }

    @Test
    public void testRemoteHostConverter() {
        RemoteHostConverter converter = new RemoteHostConverter();
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)this.request.getRemoteHost(), (Object)result);
    }

    @Test
    public void testRemoteIPAddressConverter() {
        RemoteIPAddressConverter converter = new RemoteIPAddressConverter();
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)this.request.getRemoteAddr(), (Object)result);
    }

    @Test
    public void testRemoteUserConverter() {
        RemoteUserConverter converter = new RemoteUserConverter();
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)this.request.getRemoteUser(), (Object)result);
    }

    @Test
    public void testRequestAttributeConverter() {
        RequestAttributeConverter converter = new RequestAttributeConverter();
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("testKey");
        converter.setOptionList(optionList);
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)this.request.getAttribute("testKey"), (Object)result);
    }

    @Test
    public void testRequestCookieConverter() {
        RequestCookieConverter converter = new RequestCookieConverter();
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("testName");
        converter.setOptionList(optionList);
        converter.start();
        String result = converter.convert(this.event);
        Cookie cookie = this.request.getCookies()[0];
        Assertions.assertEquals((Object)cookie.getValue(), (Object)result);
    }

    @Test
    public void testRequestHeaderConverter() {
        RequestHeaderConverter converter = new RequestHeaderConverter();
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("headerName1");
        converter.setOptionList(optionList);
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)this.request.getHeader("headerName1"), (Object)result);
    }

    @Test
    public void testRequestMethodConverter() {
        RequestMethodConverter converter = new RequestMethodConverter();
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)this.request.getMethod(), (Object)result);
    }

    @Test
    public void testRequestProtocolConverter() {
        RequestProtocolConverter converter = new RequestProtocolConverter();
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)this.request.getProtocol(), (Object)result);
    }

    @Test
    public void testRequestURIConverter() {
        RequestURIConverter converter = new RequestURIConverter();
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)this.request.getRequestURI(), (Object)result);
    }

    @Test
    public void testRequestURLConverter() {
        RequestURLConverter converter = new RequestURLConverter();
        converter.start();
        String result = converter.convert(this.event);
        String expected = this.request.getMethod() + " " + this.request.getRequestURI() + " " + this.request.getProtocol();
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    public void testResponseHeaderConverter() {
        ResponseHeaderConverter converter = new ResponseHeaderConverter();
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("headerName1");
        converter.setOptionList(optionList);
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)this.request.getHeader("headerName1"), (Object)result);
    }

    @Test
    public void testServerNameConverter() {
        ServerNameConverter converter = new ServerNameConverter();
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)this.request.getServerName(), (Object)result);
    }

    @Test
    public void testStatusCodeConverter() {
        StatusCodeConverter converter = new StatusCodeConverter();
        converter.start();
        String result = converter.convert(this.event);
        Assertions.assertEquals((Object)Integer.toString(this.event.getServerAdapter().getStatusCode()), (Object)result);
    }

    private IAccessEvent createEvent() {
        DummyServerAdapter dummyAdapter = new DummyServerAdapter(this.request, this.response);
        return new AccessEvent((Context)this.accessContext, (HttpServletRequest)this.request, (HttpServletResponse)this.response, (ServerAdapter)dummyAdapter);
    }
}

