/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.net;

import ch.qos.logback.access.dummy.DummyRequest;
import ch.qos.logback.access.dummy.DummyResponse;
import ch.qos.logback.access.dummy.DummyServerAdapter;
import ch.qos.logback.access.net.URLEvaluator;
import ch.qos.logback.access.spi.AccessContext;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.access.spi.ServerAdapter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.boolex.EvaluationException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class URLEvaluatorTest {
    final String expectedURL1 = "testUrl1";
    final String expectedURL2 = "testUrl2";
    AccessContext accessContext = new AccessContext();
    URLEvaluator evaluator;
    DummyRequest request;
    DummyResponse response;
    DummyServerAdapter serverAdapter;

    @BeforeEach
    public void setUp() throws Exception {
        this.evaluator = new URLEvaluator();
        this.evaluator.setContext((Context)this.accessContext);
        this.evaluator.addURL("testUrl1");
        this.evaluator.start();
        this.request = new DummyRequest();
        this.response = new DummyResponse();
        this.serverAdapter = new DummyServerAdapter(this.request, this.response);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.evaluator.stop();
        this.evaluator = null;
        this.request = null;
        this.response = null;
        this.serverAdapter = null;
        this.accessContext = null;
    }

    @Test
    public void testExpectFalse() throws EvaluationException {
        this.request.setRequestUri("test");
        AccessEvent ae = new AccessEvent((Context)this.accessContext, (HttpServletRequest)this.request, (HttpServletResponse)this.response, (ServerAdapter)this.serverAdapter);
        Assertions.assertFalse((boolean)this.evaluator.evaluate((IAccessEvent)ae));
    }

    @Test
    public void testExpectTrue() throws EvaluationException {
        this.request.setRequestUri("testUrl1");
        AccessEvent ae = new AccessEvent((Context)this.accessContext, (HttpServletRequest)this.request, (HttpServletResponse)this.response, (ServerAdapter)this.serverAdapter);
        Assertions.assertTrue((boolean)this.evaluator.evaluate((IAccessEvent)ae));
    }

    @Test
    public void testExpectTrueMultiple() throws EvaluationException {
        this.evaluator.addURL("testUrl2");
        this.request.setRequestUri("testUrl2");
        AccessEvent ae = new AccessEvent((Context)this.accessContext, (HttpServletRequest)this.request, (HttpServletResponse)this.response, (ServerAdapter)this.serverAdapter);
        Assertions.assertTrue((boolean)this.evaluator.evaluate((IAccessEvent)ae));
    }
}

