/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.servlet;

import ch.qos.logback.access.servlet.TeeFilter;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TeeFilterTest {
    @Test
    public void extractNameList() {
        Assertions.assertEquals(Arrays.asList("a"), (Object)TeeFilter.extractNameList((String)"a"));
        Assertions.assertEquals(Arrays.asList("a", "b"), (Object)TeeFilter.extractNameList((String)"a, b"));
        Assertions.assertEquals(Arrays.asList("a", "b"), (Object)TeeFilter.extractNameList((String)"a; b"));
        Assertions.assertEquals(Arrays.asList("a", "b", "c"), (Object)TeeFilter.extractNameList((String)"a; b, c"));
    }

    @Test
    public void defaultCase() {
        Assertions.assertTrue((boolean)TeeFilter.computeActivation((String)"somehost", (String)"", (String)""));
        Assertions.assertTrue((boolean)TeeFilter.computeActivation((String)"somehost", null, null));
    }

    @Test
    public void withIncludesOnly() {
        Assertions.assertTrue((boolean)TeeFilter.computeActivation((String)"a", (String)"a", null));
        Assertions.assertTrue((boolean)TeeFilter.computeActivation((String)"a", (String)"a, b", null));
        Assertions.assertFalse((boolean)TeeFilter.computeActivation((String)"a", (String)"b", null));
        Assertions.assertFalse((boolean)TeeFilter.computeActivation((String)"a", (String)"b, c", null));
    }

    @Test
    public void withExcludesOnly() {
        Assertions.assertFalse((boolean)TeeFilter.computeActivation((String)"a", null, (String)"a"));
        Assertions.assertFalse((boolean)TeeFilter.computeActivation((String)"a", null, (String)"a, b"));
        Assertions.assertTrue((boolean)TeeFilter.computeActivation((String)"a", null, (String)"b"));
        Assertions.assertTrue((boolean)TeeFilter.computeActivation((String)"a", null, (String)"b, c"));
    }

    @Test
    public void withIncludesAndExcludes() {
        Assertions.assertFalse((boolean)TeeFilter.computeActivation((String)"a", (String)"a", (String)"a"));
        Assertions.assertTrue((boolean)TeeFilter.computeActivation((String)"a", (String)"a", (String)"b"));
        Assertions.assertFalse((boolean)TeeFilter.computeActivation((String)"a", (String)"b", (String)"a"));
        Assertions.assertFalse((boolean)TeeFilter.computeActivation((String)"a", (String)"b", (String)"b"));
    }
}

