/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.tomcat;

import ch.qos.logback.access.tomcat.LogbackValve;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.ContainerBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogbackValveTest {
    LogbackValve valve = new LogbackValve();
    StatusChecker checker = new StatusChecker((Context)this.valve);

    @AfterEach
    public void tearDown() {
        System.clearProperty("catalina.base");
        System.clearProperty("catalina.home");
    }

    @Test
    public void nonExistingConfigFileShouldResultInWarning() throws LifecycleException {
        String resourceName = "logback-test2-config.xml";
        this.setupValve("logback-test2-config.xml");
        this.valve.start();
        this.checker.assertContainsMatch(1, "Failed to find valid");
    }

    @Test
    public void fileUnderCatalinaBaseShouldBeFound() throws LifecycleException {
        System.setProperty("catalina.base", "src/test/input/joran/tomcat/");
        String fileName = "logback-access.xml";
        this.setupValve("logback-access.xml");
        this.valve.start();
        this.checker.assertContainsMatch("Found configuration file");
        this.checker.assertContainsMatch("Done configuring");
        this.checker.assertIsErrorFree();
    }

    @Test
    public void nonExistingConfigFileUnderCatalinaBaseShouldResultInWarning() throws LifecycleException {
        String path = "src/test/input/joran/tomcat/";
        String fileName = "logback-test2-config.xml";
        String fullPath = "src/test/input/joran/tomcat/logback-test2-config.xml";
        System.setProperty("catalina.base", "src/test/input/joran/tomcat/");
        this.setupValve("logback-test2-config.xml");
        this.valve.start();
        this.checker.assertContainsMatch("Could NOT find configuration file");
        this.checker.assertIsErrorFree();
    }

    @Test
    public void fileUnderCatalinaHomeShouldBeFound() throws LifecycleException {
        System.setProperty("catalina.home", "src/test/input/joran/tomcat/");
        String fileName = "logback-access.xml";
        this.setupValve("logback-access.xml");
        this.valve.start();
        this.checker.assertContainsMatch("Found configuration file");
        this.checker.assertContainsMatch("Done configuring");
        this.checker.assertIsErrorFree();
    }

    @Test
    public void resourceShouldBeFound() throws LifecycleException {
        String fileName = "logback-asResource.xml";
        this.setupValve("logback-asResource.xml");
        this.valve.start();
        this.checker.assertContainsMatch("Found .logback-asResource.xml. as a resource.");
        this.checker.assertContainsMatch("Done configuring");
        this.checker.assertIsErrorFree();
    }

    @Test
    public void executorServiceShouldBeNotNull() throws LifecycleException {
        String fileName = "logback-asResource.xml";
        this.setupValve("logback-asResource.xml");
        this.valve.start();
        Assertions.assertNotNull((Object)this.valve.getScheduledExecutorService());
    }

    private void setupValve(String resourceName) {
        this.valve.setFilename(resourceName);
        this.valve.setName("test");
        this.valve.setContainer((Container)new ContainerBase(){

            protected String getObjectNameKeyProperties() {
                return "getObjectNameKeyProperties-test";
            }
        });
    }
}

