/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.servlet;

import ch.qos.logback.access.dummy.DummyResponse;
import ch.qos.logback.access.dummy.DummyServletOutputStream;
import ch.qos.logback.access.servlet.TeeHttpServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TeeHttpServletResponseTest {
    public static Stream<Arguments> inputValues() {
        return Stream.of(Arguments.of((Object[])new Object[]{"utf-8", "G\u00fclc\u00fc", new byte[]{71, -61, -68, 108, 99, -61, -68}}), Arguments.of((Object[])new Object[]{"iso-8859-1", "G\u00fclc\u00fc", new byte[]{71, -4, 108, 99, -4}}));
    }

    @ParameterizedTest
    @MethodSource(value={"inputValues"})
    public void testWriterEncoding(String characterEncoding, String testString, byte[] expectedBytes) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DummyResponse dummyResponse = new DummyResponse();
        dummyResponse.setCharacterEncoding(characterEncoding);
        dummyResponse.setOutputStream(new DummyServletOutputStream(byteArrayOutputStream));
        TeeHttpServletResponse teeServletResponse = new TeeHttpServletResponse((HttpServletResponse)dummyResponse);
        PrintWriter writer = teeServletResponse.getWriter();
        writer.write(testString);
        writer.flush();
        Assertions.assertArrayEquals((byte[])expectedBytes, (byte[])byteArrayOutputStream.toByteArray());
    }
}

