/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.LoggerContextRemoteView;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.util.HashMap;
import java.util.Hashtable;
import org.slf4j.ILoggerFactory;

public class LoggerContext
extends ContextBase
implements ILoggerFactory {
    public static final String ROOT_NAME = "root";
    final Logger root;
    private int size;
    private int noAppenderWarning = 0;
    private Hashtable<String, Logger> loggerCache = new Hashtable();
    LoggerContextRemoteView loggerContextRemoteView = new LoggerContextRemoteView(this);

    public LoggerContext() {
        this.root = new Logger(ROOT_NAME, null, this);
        this.root.setLevel(Level.DEBUG);
        this.loggerCache.put(ROOT_NAME, this.root);
        this.putObject("EVALUATOR_MAP", new HashMap());
        this.size = 1;
    }

    private void syncRemoteView() {
        this.loggerContextRemoteView = new LoggerContextRemoteView(this);
        for (Logger logger : this.loggerCache.values()) {
            logger.buildRemoteView();
        }
    }

    public void setName(String name) {
        super.setName(name);
        this.syncRemoteView();
    }

    public final Logger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Logger getLogger(String name) {
        int h;
        if (ROOT_NAME.equalsIgnoreCase(name)) {
            return this.root;
        }
        int i = 0;
        Logger logger = this.root;
        Logger childLogger = this.loggerCache.get(name);
        if (childLogger != null) {
            return childLogger;
        }
        do {
            String childName = (h = name.indexOf(46, i)) == -1 ? name : name.substring(0, h);
            i = h + 1;
            Logger logger2 = logger;
            synchronized (logger2) {
                childLogger = logger.getChildByName(childName);
                if (childLogger == null) {
                    childLogger = logger.createChildByName(childName);
                    this.loggerCache.put(childName, childLogger);
                    this.incSize();
                }
            }
            logger = childLogger;
        } while (h != -1);
        return childLogger;
    }

    private synchronized void incSize() {
        ++this.size;
    }

    int size() {
        return this.size;
    }

    Logger exists(String name) {
        return this.loggerCache.get(name);
    }

    final void noAppenderDefinedWarning(Logger logger) {
        if (this.noAppenderWarning++ == 0) {
            this.getStatusManager().add((Status)new ErrorStatus("No appenders present in context [" + this.getName() + "] for logger [" + logger.getName() + "].", (Object)logger));
        }
    }

    public LoggerContextRemoteView getLoggerContextRemoteView() {
        return this.loggerContextRemoteView;
    }
}

