/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;

public class SocketAppender
extends AppenderBase {
    static final int DEFAULT_PORT = 4560;
    static final int DEFAULT_RECONNECTION_DELAY = 30000;
    String remoteHost;
    InetAddress address;
    int port = 4560;
    ObjectOutputStream oos;
    int reconnectionDelay = 30000;
    private Connector connector;
    int counter = 0;
    private static final int RESET_FREQUENCY = 70;

    public SocketAppender() {
    }

    public SocketAppender(InetAddress address, int port) {
        this.address = address;
        this.remoteHost = address.getHostName();
        this.port = port;
    }

    public SocketAppender(String host, int port) {
        this.port = port;
        this.address = SocketAppender.getAddressByName(host);
        this.remoteHost = host;
    }

    public void start() {
        int errorCount = 0;
        if (this.port == 0) {
            ++errorCount;
            this.addError("No port was configured for appender" + this.name);
        }
        if (this.address == null) {
            ++errorCount;
            this.addError("No remote address was configured for appender" + this.name);
        }
        this.connect(this.address, this.port);
        if (errorCount == 0) {
            this.started = true;
        }
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        this.started = false;
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (IOException e) {
                this.addError("Could not close oos.", e);
            }
            this.oos = null;
        }
        if (this.connector != null) {
            this.addInfo("Interrupting the connector.");
            this.connector.interrupted = true;
            this.connector = null;
        }
    }

    void connect(InetAddress address, int port) {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.oos = new ObjectOutputStream(new Socket(address, port).getOutputStream());
        }
        catch (IOException e) {
            String msg = "Could not connect to remote logback server at [" + address.getHostName() + "].";
            if (this.reconnectionDelay > 0) {
                msg = msg + " We will try again later.";
                this.fireConnector();
            }
            this.addError(msg, e);
        }
    }

    protected void append(Object event) {
        block6: {
            if (event == null) {
                return;
            }
            if (this.address == null) {
                this.addError("No remote host is set for SocketAppender named \"" + this.name + "\".");
                return;
            }
            if (this.oos != null) {
                try {
                    this.oos.writeObject(event);
                    this.oos.flush();
                    if (++this.counter >= 70) {
                        this.counter = 0;
                        this.oos.reset();
                    }
                }
                catch (IOException e) {
                    this.oos = null;
                    this.addWarn("Detected problem with connection: " + e);
                    if (this.reconnectionDelay <= 0) break block6;
                    this.fireConnector();
                }
            }
        }
    }

    void fireConnector() {
        if (this.connector == null) {
            this.addInfo("Starting a new connector thread.");
            this.connector = new Connector();
            this.connector.setDaemon(true);
            this.connector.setPriority(1);
            this.connector.start();
        }
    }

    static InetAddress getAddressByName(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setRemoteHost(String host) {
        this.address = SocketAppender.getAddressByName(host);
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(int delay) {
        this.reconnectionDelay = delay;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public Layout getLayout() {
        return null;
    }

    public void setLayout(Layout layout) {
    }

    class Connector
    extends Thread {
        boolean interrupted = false;

        Connector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.interrupted) {
                try {
                    Connector.sleep(SocketAppender.this.reconnectionDelay);
                    SocketAppender.this.addInfo("Attempting connection to " + SocketAppender.this.address.getHostName());
                    Socket socket = new Socket(SocketAppender.this.address, SocketAppender.this.port);
                    Connector connector = this;
                    synchronized (connector) {
                        SocketAppender.this.oos = new ObjectOutputStream(socket.getOutputStream());
                        SocketAppender.this.connector = null;
                        SocketAppender.this.addInfo("Connection established. Exiting connector thread.");
                        break;
                    }
                }
                catch (InterruptedException e) {
                    SocketAppender.this.addInfo("Connector interrupted. Leaving loop.");
                    return;
                }
                catch (ConnectException e) {
                    SocketAppender.this.addInfo("Remote host " + SocketAppender.this.address.getHostName() + " refused connection.");
                }
                catch (IOException e) {
                    SocketAppender.this.addInfo("Could not connect to " + SocketAppender.this.address.getHostName() + ". Exception is " + e);
                }
            }
        }
    }
}

