/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.appender.ListAppender;
import junit.framework.TestCase;

public class MessageFormattingTest
extends TestCase {
    LoggerContext lc;
    ListAppender listAppender;

    public void setUp() {
        this.lc = new LoggerContext();
        Logger logger = this.lc.getLogger("root");
        this.listAppender = new ListAppender();
        this.listAppender.setContext((Context)this.lc);
        this.listAppender.start();
        logger.addAppender((Appender)this.listAppender);
    }

    public void testFormattingOneArg() {
        Logger logger = this.lc.getLogger("root");
        logger.debug("{}", (Object)new Integer(12));
        LoggingEvent event = (LoggingEvent)this.listAppender.list.get(0);
        MessageFormattingTest.assertEquals((String)"12", (String)event.getFormattedMessage());
    }

    public void testFormattingTwoArg() {
        Logger logger = this.lc.getLogger("root");
        logger.debug("{}-{}", (Object)new Integer(12), (Object)new Integer(13));
        LoggingEvent event = (LoggingEvent)this.listAppender.list.get(0);
        MessageFormattingTest.assertEquals((String)"12-13", (String)event.getFormattedMessage());
    }

    public void testNoFormatting() {
        Logger logger = this.lc.getLogger("root");
        logger.debug("test", (Object)new Integer(12), (Object)new Integer(13));
        LoggingEvent event = (LoggingEvent)this.listAppender.list.get(0);
        MessageFormattingTest.assertEquals((String)"test", (String)event.getFormattedMessage());
    }

    public void testNoFormatting2() {
        Logger logger = this.lc.getLogger("root");
        logger.debug("test");
        LoggingEvent event = (LoggingEvent)this.listAppender.list.get(0);
        MessageFormattingTest.assertEquals((String)"test", (String)event.getFormattedMessage());
    }

    public void testMessageConverter() {
        Logger logger = this.lc.getLogger("root");
        logger.debug("{}", (Object)12);
        LoggingEvent event = (LoggingEvent)this.listAppender.list.get(0);
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)this.lc);
        layout.setPattern("%m");
        layout.start();
        String formattedMessage = layout.doLayout(event);
        MessageFormattingTest.assertEquals((String)"12", (String)formattedMessage);
    }
}

