/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.ConverterTest;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.FormattingConverter;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.pattern.parser.AbstractPatternLayoutBaseTest;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;

public class PatternLayoutTest
extends AbstractPatternLayoutBaseTest {
    LoggerContext lc = new LoggerContext();
    Logger logger = this.lc.getLogger(ConverterTest.class);
    LoggingEvent le;
    List optionList = new ArrayList();

    public PatternLayoutTest(String arg0) {
        super(arg0);
        Exception ex = new Exception("Bogus exception");
        this.le = this.makeLoggingEvent(ex);
    }

    LoggingEvent makeLoggingEvent(Exception ex) {
        return new LoggingEvent(FormattingConverter.class.getName(), this.logger, Level.INFO, "Some message", (Throwable)ex, null);
    }

    public Object getEventObject() {
        return this.makeLoggingEvent(null);
    }

    public PatternLayoutBase getPatternLayoutBase() {
        return new PatternLayout();
    }

    public void testOK() {
        PatternLayout pl = new PatternLayout();
        pl.setPattern("%d %le [%t] %lo{30} - %m%n");
        LoggerContext context = new LoggerContext();
        pl.setContext((Context)context);
        pl.start();
        String val = pl.doLayout(this.getEventObject());
        String regex = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} INFO \\[main] c.q.l.c.pattern.ConverterTest - Some message\\s*";
        PatternLayoutTest.assertTrue((boolean)val.matches(regex));
    }

    public void testNoExeptionHandler() {
        PatternLayout pl = new PatternLayout();
        pl.setPattern("%m%n");
        LoggerContext context = new LoggerContext();
        pl.setContext((Context)context);
        pl.start();
        String val = pl.doLayout(this.le);
        PatternLayoutTest.assertTrue((boolean)val.contains("java.lang.Exception: Bogus exception"));
    }

    public void testNopExeptionHandler() {
        PatternLayout pl = new PatternLayout();
        pl.setPattern("%nopex %m%n");
        LoggerContext context = new LoggerContext();
        pl.setContext((Context)context);
        pl.start();
        String val = pl.doLayout(this.le);
        PatternLayoutTest.assertTrue((!val.contains("java.lang.Exception: Bogus exception") ? 1 : 0) != 0);
    }

    public void testWithLettersComingFromLog4j() {
        PatternLayout pl = new PatternLayout();
        pl.setPattern("%d %p [%t] %c{30} - %m%n");
        LoggerContext context = new LoggerContext();
        pl.setContext((Context)context);
        pl.start();
        String val = pl.doLayout(this.getEventObject());
        String regex = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} INFO \\[main] c.q.l.c.pattern.ConverterTest - Some message\\s*";
        PatternLayoutTest.assertTrue((boolean)val.matches(regex));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(PatternLayoutTest.class);
        return suite;
    }
}

