/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.html;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.html.DefaultThrowableRenderer;
import ch.qos.logback.classic.html.HTMLLayout;
import ch.qos.logback.classic.html.XHTMLEntityResolver;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableInformation;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.appender.ListAppender;
import ch.qos.logback.core.html.IThrowableRenderer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;

public class HTMLLayoutTest
extends TestCase {
    LoggerContext lc;
    Logger logger;
    HTMLLayout layout;

    public void setUp() throws Exception {
        super.setUp();
        this.lc = new LoggerContext();
        this.lc.setName("default");
        ListAppender appender = new ListAppender();
        appender.setContext((Context)this.lc);
        this.layout = new HTMLLayout();
        this.layout.setThrowableRenderer((IThrowableRenderer)new DefaultThrowableRenderer());
        this.layout.setContext((Context)this.lc);
        this.layout.setPattern("%level%thread%msg");
        this.layout.start();
        appender.setLayout((Layout)this.layout);
        this.logger = this.lc.getLogger("root");
        this.logger.addAppender((Appender)appender);
        appender.start();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.lc = null;
        this.layout = null;
    }

    public void testHeader() {
        String header = this.layout.getHeader();
        Document doc = this.parseOutput(header + "</table></body></html>");
        Element rootElement = doc.getRootElement();
        Element bodyElement = rootElement.element("body");
        Element tableElement = bodyElement.element("table");
        Element trElement = tableElement.element("tr");
        List elementList = trElement.elements();
        HTMLLayoutTest.assertEquals((String)"Level", (String)((Element)elementList.get(0)).getText());
        HTMLLayoutTest.assertEquals((String)"Thread", (String)((Element)elementList.get(1)).getText());
        HTMLLayoutTest.assertEquals((String)"Message", (String)((Element)elementList.get(2)).getText());
    }

    public void testAppendThrowable() throws Exception {
        StringBuffer buf = new StringBuffer();
        String[] strArray = new String[]{"test1", "test2"};
        DefaultThrowableRenderer renderer = (DefaultThrowableRenderer)this.layout.getThrowableRenderer();
        renderer.render(buf, strArray);
        String[] result = buf.toString().split(HTMLLayout.LINE_SEP);
        HTMLLayoutTest.assertEquals((String)"<tr><td class=\"Exception\" colspan=\"6\">test1", (String)result[0]);
        HTMLLayoutTest.assertEquals((String)"<br />&nbsp;&nbsp;&nbsp;&nbsp;test2", (String)result[1]);
    }

    public void testDoLayout() throws Exception {
        LoggingEvent le = this.createLoggingEvent();
        String result = this.layout.doLayout(le);
        Document doc = this.parseOutput(result);
        Element trElement = doc.getRootElement();
        HTMLLayoutTest.assertEquals((int)3, (int)trElement.elements().size());
        Element tdElement = (Element)trElement.elements().get(0);
        HTMLLayoutTest.assertEquals((String)"DEBUG", (String)tdElement.getText());
        tdElement = (Element)trElement.elements().get(1);
        HTMLLayoutTest.assertEquals((String)"main", (String)tdElement.getText());
        tdElement = (Element)trElement.elements().get(2);
        HTMLLayoutTest.assertEquals((String)"test message", (String)tdElement.getText());
    }

    public void testDoLayoutWithException() throws Exception {
        this.layout.setPattern("%level %thread %msg %ex");
        LoggingEvent le = this.createLoggingEvent();
        le.setThrowableInformation(new ThrowableInformation((Throwable)new Exception("test Exception")));
        String result = this.layout.doLayout(le);
        String stringToParse = this.layout.getHeader();
        stringToParse = stringToParse + result;
        stringToParse = stringToParse + "</table></body></html>";
        Document doc = this.parseOutput(stringToParse);
        Element rootElement = doc.getRootElement();
        Element bodyElement = rootElement.element("body");
        Element tableElement = bodyElement.element("table");
        List trElementList = tableElement.elements();
        Element exceptionRowElement = (Element)trElementList.get(2);
        Element exceptionElement = exceptionRowElement.element("td");
        HTMLLayoutTest.assertEquals((int)3, (int)tableElement.elements().size());
        HTMLLayoutTest.assertTrue((boolean)exceptionElement.getText().contains("java.lang.Exception: test Exception"));
    }

    private LoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent(((Object)((Object)this)).getClass().getName(), this.logger, Level.DEBUG, "test message", null, null);
        return le;
    }

    Document parseOutput(String output) {
        XHTMLEntityResolver resolver = new XHTMLEntityResolver();
        SAXReader reader = new SAXReader();
        reader.setEntityResolver((EntityResolver)resolver);
        Document doc = null;
        try {
            doc = reader.read((InputStream)new ByteArrayInputStream(output.getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }
}

