/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.appender.ListAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class BasicJoranTest
extends TestCase {
    public BasicJoranTest(String name) {
        super(name);
    }

    public void testSimpleList() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/simpleList.xml");
        StatusPrinter.print((StatusManager)loggerContext.getStatusManager());
        Logger logger = loggerContext.getLogger(((Object)((Object)this)).getClass().getName());
        Logger root = loggerContext.getLogger("root");
        ListAppender listAppender = (ListAppender)root.getAppender("LIST");
        BasicJoranTest.assertEquals((int)0, (int)listAppender.list.size());
        String msg = "hello world";
        logger.debug(msg);
        BasicJoranTest.assertEquals((int)1, (int)listAppender.list.size());
        LoggingEvent le = (LoggingEvent)listAppender.list.get(0);
        BasicJoranTest.assertEquals((String)msg, (String)le.getMessage());
    }

    public void testLevel() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/simpleLevel.xml");
        StatusPrinter.print((StatusManager)loggerContext.getStatusManager());
        Logger logger = loggerContext.getLogger(((Object)((Object)this)).getClass().getName());
        Logger root = loggerContext.getLogger("root");
        ListAppender listAppender = (ListAppender)root.getAppender("LIST");
        BasicJoranTest.assertEquals((int)0, (int)listAppender.list.size());
        String msg = "hello world";
        logger.debug(msg);
        BasicJoranTest.assertEquals((int)0, (int)listAppender.list.size());
    }

    public void testEval() throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        LoggerContext loggerContext = new LoggerContext();
        jc.setContext((Context)loggerContext);
        jc.doConfigure("src/test/input/joran/callerData.xml");
        StatusPrinter.print((StatusManager)loggerContext.getStatusManager());
        Logger logger = loggerContext.getLogger(((Object)((Object)this)).getClass().getName());
        String msg = "hello world";
        logger.debug("toto");
        logger.debug(msg);
    }

    public static Test COMMENTED_OUT_suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new BasicJoranTest("testLevel"));
        return suite;
    }
}

