/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.MDC;
import ch.qos.logback.classic.pattern.CallerDataConverter;
import ch.qos.logback.classic.pattern.ClassOfCallerConverter;
import ch.qos.logback.classic.pattern.FileOfCallerConverter;
import ch.qos.logback.classic.pattern.LevelConverter;
import ch.qos.logback.classic.pattern.LineOfCallerConverter;
import ch.qos.logback.classic.pattern.LineSeparatorConverter;
import ch.qos.logback.classic.pattern.LoggerConverter;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.pattern.MethodOfCallerConverter;
import ch.qos.logback.classic.pattern.RelativeTimeConverter;
import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.pattern.ThreadConverter;
import ch.qos.logback.classic.pattern.ThrowableInformationConverter;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.CoreGlobal;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.FormattingConverter;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.slf4j.MarkerFactory;

public class ConverterTest
extends TestCase {
    LoggerContext lc = new LoggerContext();
    Logger logger = this.lc.getLogger(ConverterTest.class);
    LoggingEvent le;
    List<String> optionList = new ArrayList<String>();

    public ConverterTest(String arg0) {
        super(arg0);
        Exception rootEx = this.getException("Innermost", null);
        Exception nestedEx = this.getException("Nested", rootEx);
        Exception ex = new Exception("Bogus exception", nestedEx);
        this.le = this.makeLoggingEvent(ex);
    }

    LoggingEvent makeLoggingEvent(Exception ex) {
        return new LoggingEvent(FormattingConverter.class.getName(), this.logger, Level.INFO, "Some message", (Throwable)ex, null);
    }

    Exception getException(String msg, Exception cause) {
        return new Exception(msg, cause);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLineOfCaller() {
        LineOfCallerConverter converter = new LineOfCallerConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        ConverterTest.assertEquals((String)"74", (String)buf.toString());
    }

    public void testLevel() {
        LevelConverter converter = new LevelConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        ConverterTest.assertEquals((String)"INFO", (String)buf.toString());
        converter = new LevelConverter();
        converter.setFormattingInfo(new FormatInfo(1, 1, true, false));
        buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        ConverterTest.assertEquals((String)"I", (String)buf.toString());
    }

    public void testThread() {
        ThreadConverter converter = new ThreadConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        ConverterTest.assertEquals((String)"main", (String)buf.toString());
    }

    public void testMessage() {
        MessageConverter converter = new MessageConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        ConverterTest.assertEquals((String)"Some message", (String)buf.toString());
    }

    public void testLineSeparator() {
        LineSeparatorConverter converter = new LineSeparatorConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        ConverterTest.assertEquals((String)CoreGlobal.LINE_SEPARATOR, (String)buf.toString());
    }

    public void testException() {
        ThrowableInformationConverter converter = new ThrowableInformationConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        System.out.println(buf);
        converter = new ThrowableInformationConverter();
        this.optionList.add("3");
        converter.setOptionList(this.optionList);
        buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        System.out.println(buf);
    }

    public void testLogger() {
        LoggerConverter converter = new LoggerConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        ConverterTest.assertEquals((String)((Object)((Object)this)).getClass().getName(), (String)buf.toString());
        converter = new LoggerConverter();
        this.optionList.add("20");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        ConverterTest.assertEquals((String)"c.q.l.c.p.ConverterTest", (String)buf.toString());
    }

    public void testClass() {
        ClassOfCallerConverter converter = new ClassOfCallerConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        ConverterTest.assertEquals((String)((Object)((Object)this)).getClass().getName(), (String)buf.toString());
    }

    public void testMethodOfCaller() {
        MethodOfCallerConverter converter = new MethodOfCallerConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        ConverterTest.assertEquals((String)"testMethodOfCaller", (String)buf.toString());
    }

    public void testFileOfCaller() {
        FileOfCallerConverter converter = new FileOfCallerConverter();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        ConverterTest.assertEquals((String)"ConverterTest.java", (String)buf.toString());
    }

    public void testCallerData() {
        CallerDataConverter converter = new CallerDataConverter();
        converter.start();
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        if (buf.length() < 10) {
            ConverterTest.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        this.optionList.add("2");
        this.optionList.add("XXX");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuffer();
        LoggingEvent event = this.makeLoggingEvent(null);
        event.setMarker(MarkerFactory.getMarker((String)"XXX"));
        converter.write(buf, (Object)event);
        if (buf.length() < 10) {
            ConverterTest.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        this.optionList.clear();
        this.optionList.add("2");
        this.optionList.add("XXX");
        this.optionList.add("*");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuffer();
        event = this.makeLoggingEvent(null);
        event.setMarker(MarkerFactory.getMarker((String)"YYY"));
        converter.write(buf, (Object)event);
        if (buf.length() < 10) {
            ConverterTest.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        this.optionList.clear();
        this.optionList.add("2");
        this.optionList.add("XXX");
        this.optionList.add("+");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuffer();
        event = this.makeLoggingEvent(null);
        event.setMarker(MarkerFactory.getMarker((String)"YYY"));
        converter.write(buf, (Object)event);
        if (buf.length() < 10) {
            ConverterTest.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        this.optionList.clear();
        this.optionList.add("2");
        this.optionList.add("XXX");
        this.optionList.add("*");
        converter.setOptionList(this.optionList);
        converter.start();
        buf = new StringBuffer();
        converter.write(buf, (Object)this.le);
        if (buf.length() < 10) {
            ConverterTest.fail((String)"buf is too short");
        }
        System.out.println(buf);
    }

    public void testRelativeTime() throws Exception {
        RelativeTimeConverter converter = new RelativeTimeConverter();
        Thread.sleep(100L);
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)this.makeLoggingEvent(null));
        int rt = Integer.parseInt(buf.toString());
        if (rt < 50) {
            ConverterTest.fail((String)("relative time should be > 50, but it is " + rt));
        }
    }

    public void testSyslogStart() throws Exception {
        SyslogStartConverter converter = new SyslogStartConverter();
        this.optionList.clear();
        this.optionList.add("MAIL");
        converter.setOptionList(this.optionList);
        converter.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        StringBuffer buf = new StringBuffer();
        converter.write(buf, (Object)event);
        String expected = "<22>";
        ConverterTest.assertTrue((boolean)buf.toString().startsWith(expected));
    }

    public void testMDCConverter() throws Exception {
        MDC.clear();
        MDC.put((String)"someKey", (String)"someValue");
        MDCConverter converter = new MDCConverter();
        this.optionList.clear();
        this.optionList.add("someKey");
        converter.setOptionList(this.optionList);
        converter.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        String result = converter.convert((Object)event);
        ConverterTest.assertEquals((String)"someValue", (String)result);
    }
}

