/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.StatusPrinter;
import java.net.URL;

public class ContextInitializer {
    public static final String AUTOCONFIG_FILE = "logback.xml";
    public static final String TEST_AUTOCONFIG_FILE = "logback-test.xml";

    public static void configureByResource(LoggerContext loggerContext, URL url) throws JoranException {
        if (url == null) {
            throw new IllegalArgumentException("URL argument cannot be null");
        }
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)loggerContext);
        configurator.doConfigure(url);
    }

    public static void autoConfig(LoggerContext loggerContext) {
        URL url = Loader.getResource((String)AUTOCONFIG_FILE);
        if (url == null) {
            url = Loader.getResource((String)TEST_AUTOCONFIG_FILE);
        }
        if (url != null) {
            try {
                ContextInitializer.configureByResource(loggerContext, url);
            }
            catch (JoranException je) {
                StatusPrinter.print((Context)loggerContext);
            }
        }
    }
}

