/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.boolex;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.boolex.JaninoEventEvaluator;
import ch.qos.logback.classic.pattern.ConverterTest;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.Matcher;
import ch.qos.logback.core.pattern.FormattingConverter;
import junit.framework.TestCase;
import org.slf4j.MarkerFactory;

public class JaninoEventEvaluatorTest
extends TestCase {
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(ConverterTest.class);
    Matcher matcherX = new Matcher();
    static final long LEN = 10000L;

    public JaninoEventEvaluatorTest(String arg0) {
        super(arg0);
        this.matcherX.setName("x");
        this.matcherX.setRegex("^Some\\s.*");
        this.matcherX.start();
    }

    LoggingEvent makeLoggingEvent(Exception ex) {
        LoggingEvent e = new LoggingEvent(FormattingConverter.class.getName(), this.logger, Level.INFO, "Some message", (Throwable)ex, null);
        return e;
    }

    public void testBasic() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("message.equals(\"Some message\")");
        jee.setContext((Context)this.loggerContext);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        JaninoEventEvaluatorTest.assertTrue((boolean)jee.evaluate((Object)event));
    }

    public void testLevel() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("level > DEBUG");
        jee.setContext((Context)this.loggerContext);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        JaninoEventEvaluatorTest.assertTrue((boolean)jee.evaluate((Object)event));
    }

    public void testtimeStamp() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("timeStamp > 10");
        jee.setContext((Context)this.loggerContext);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        JaninoEventEvaluatorTest.assertTrue((boolean)jee.evaluate((Object)event));
    }

    public void testWithMatcher() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("x.matches(message)");
        jee.setContext((Context)this.loggerContext);
        jee.addMatcher(this.matcherX);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        JaninoEventEvaluatorTest.assertTrue((boolean)jee.evaluate((Object)event));
    }

    public void testMarker() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("marker.contains(\"BLUE\")");
        jee.setContext((Context)this.loggerContext);
        jee.addMatcher(this.matcherX);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        event.setMarker(MarkerFactory.getMarker((String)"BLUE"));
        JaninoEventEvaluatorTest.assertTrue((boolean)jee.evaluate((Object)event));
    }

    public void testWithNullMarker() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("marker.contains(\"BLUE\")");
        jee.setContext((Context)this.loggerContext);
        jee.addMatcher(this.matcherX);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        try {
            jee.evaluate((Object)event);
            JaninoEventEvaluatorTest.fail((String)"We should not reach this point");
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
    }

    public void testComplex() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("level >= INFO && x.matches(message) && marker.contains(\"BLUE\")");
        jee.setContext((Context)this.loggerContext);
        jee.addMatcher(this.matcherX);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        event.setMarker(MarkerFactory.getMarker((String)"BLUE"));
        JaninoEventEvaluatorTest.assertTrue((boolean)jee.evaluate((Object)event));
    }

    public void testBogusExp1() {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("mzzzz.get(\"key\").equals(null)");
        jee.setContext((Context)this.loggerContext);
        jee.setName("bogus");
        jee.start();
        JaninoEventEvaluatorTest.assertFalse((boolean)jee.isStarted());
    }

    public void testBogusExp2() {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("mdc.get(\"keyXN89\").equals(null)");
        jee.setContext((Context)this.loggerContext);
        jee.setName("bogus");
        jee.start();
        JaninoEventEvaluatorTest.assertTrue((boolean)jee.isStarted());
        LoggingEvent event = this.makeLoggingEvent(null);
        for (int i = 0; i < 4; ++i) {
            try {
                jee.evaluate((Object)event);
                JaninoEventEvaluatorTest.fail((String)"should throw an exception");
                continue;
            }
            catch (EvaluationException e) {
                // empty catch block
            }
        }
        JaninoEventEvaluatorTest.assertFalse((boolean)jee.isStarted());
    }

    void loop(JaninoEventEvaluator jee, String msg) throws Exception {
        LoggingEvent event = this.makeLoggingEvent(null);
        int i = 0;
        while ((long)i < 10000L) {
            jee.evaluate((Object)event);
            ++i;
        }
    }

    public void testLoop1() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("timeStamp > 10");
        jee.setContext((Context)this.loggerContext);
        jee.start();
        this.loop(jee, "timestamp > 10]: ");
    }

    public void testLoop2() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("x.matches(message)");
        jee.setContext((Context)this.loggerContext);
        jee.addMatcher(this.matcherX);
        jee.start();
        this.loop(jee, "x.matches(message): ");
    }
}

