/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.impl.MarkerIgnoringBase;

public class HLogger
extends MarkerIgnoringBase {
    static int instanceCount = 0;
    private String name;
    private Level level;
    private Level effectiveLevel;
    HLogger parent;
    Map<String, HLogger> childrenMap;
    private ArrayList<Appender<LoggingEvent>> appenderList;
    protected boolean additive = true;

    HLogger(String name, HLogger parent) {
        this.name = name;
        this.parent = parent;
        ++instanceCount;
    }

    Level getEffectiveLevel() {
        return this.effectiveLevel;
    }

    Level getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    private final boolean isRootLogger() {
        return this.parent == null;
    }

    HLogger getChildBySuffix(String suffix) {
        if (this.childrenMap == null) {
            return null;
        }
        return this.childrenMap.get(suffix);
    }

    public synchronized void setLevel(Level newLevel) {
        if (this.level == newLevel) {
            return;
        }
        this.level = newLevel;
        this.effectiveLevel = newLevel;
        if (this.childrenMap != null) {
            for (HLogger child : this.childrenMap.values()) {
                child.handleParentLevelChange(this.effectiveLevel);
            }
        }
    }

    private synchronized void handleParentLevelChange(Level newParentLevel) {
        if (this.level == null) {
            this.effectiveLevel = newParentLevel;
            if (this.childrenMap != null) {
                for (HLogger child : this.childrenMap.values()) {
                    child.handleParentLevelChange(this.effectiveLevel);
                }
            }
        }
    }

    public synchronized void removeAllAppenders() {
        if (this.appenderList != null) {
            int len = this.appenderList.size();
            for (int i = 0; i < len; ++i) {
                Appender<LoggingEvent> a = this.appenderList.get(i);
                a.stop();
            }
            this.appenderList.clear();
            this.appenderList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callAppenders(LoggingEvent event) {
        int writes = 0;
        HLogger l = this;
        while (l != null) {
            HLogger hLogger = l;
            synchronized (hLogger) {
                if (l.appenderList != null) {
                    writes += l.appendLoopOnAppenders(event);
                }
                if (!l.additive) {
                    break;
                }
            }
            l = l.parent;
        }
    }

    private int appendLoopOnAppenders(LoggingEvent event) {
        int size = 0;
        if (this.appenderList != null) {
            size = this.appenderList.size();
            for (int i = 0; i < size; ++i) {
                Appender<LoggingEvent> appender = this.appenderList.get(i);
                appender.doAppend((Object)event);
            }
        }
        return size;
    }

    public synchronized void removeAppender(Appender appender) {
        if (appender == null || this.appenderList == null) {
            // empty if block
        }
        this.appenderList.remove(appender);
    }

    HLogger createChildByLastNamePart(String lastPart) {
        int i_index = lastPart.indexOf(46);
        if (i_index != -1) {
            throw new IllegalArgumentException("Child name [" + lastPart + " passed as parameter, may not include [" + '.' + "]");
        }
        if (this.childrenMap == null) {
            this.childrenMap = new HashMap<String, HLogger>(2);
        }
        HLogger childHLogger = this.isRootLogger() ? new HLogger(lastPart, this) : new HLogger(this.name + '.' + lastPart, this);
        this.childrenMap.put(lastPart, childHLogger);
        childHLogger.effectiveLevel = this.effectiveLevel;
        return childHLogger;
    }

    public final void debug(String msg) {
        if (this.effectiveLevel.levelInt <= 10000) {
            throw new UnsupportedOperationException("not yet implemented");
        }
    }

    public void debug(String msg, Throwable t) {
    }

    public void debug(Object parameterizedMsg, Object param1) {
    }

    public void debug(String parameterizedMsg, Object param1, Object param2) {
    }

    public void error(String msg) {
    }

    public void error(String msg, Throwable t) {
    }

    public void error(String parameterizedMsg, Object param1) {
    }

    public void error(String parameterizedMsg, Object param1, Object param2) {
    }

    public void info(String msg) {
    }

    public void info(String msg, Throwable t) {
    }

    public void info(String parameterizedMsg, Object param1) {
    }

    public void info(String parameterizedMsg, Object param1, Object param2) {
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public boolean isErrorEnabled() {
        return false;
    }

    public boolean isInfoEnabled() {
        return false;
    }

    public boolean isWarnEnabled() {
        return false;
    }

    public void warn(String msg) {
    }

    public void warn(String msg, Throwable t) {
    }

    public void warn(String parameterizedMsg, Object param1) {
    }

    public void warn(String parameterizedMsg, Object param1, Object param2) {
    }

    public void debug(String format, Object arg) {
    }

    public void debug(String format, Object[] argArray) {
    }

    public void info(String format, Object[] argArray) {
    }

    public void warn(String format, Object[] argArray) {
    }

    public void error(String format, Object[] argArray) {
    }
}

