/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.NOPTurboFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.appender.NOPAppender;
import java.net.InetAddress;
import junit.framework.TestCase;

public class LoggerPerfTest
extends TestCase {
    static final String KAL = "kal";
    String localhostName = null;

    public void setUp() throws Exception {
        this.localhostName = InetAddress.getLocalHost().getCanonicalHostName();
    }

    public void testSpeed() {
        long len = 10000000L;
        this.loopBasic(len);
        double avg = this.loopBasic(len);
        System.out.println("Running on " + this.localhostName);
        if (KAL.equals(this.localhostName)) {
            LoggerPerfTest.assertTrue((30.0 > avg ? 1 : 0) != 0);
        }
        System.out.println("Average log time for disabled statements: " + avg + " nanos.");
    }

    public void testNOPFilterSpeed() {
        long len = 10000000L;
        this.loopNopFilter(len);
        double avg = this.loopNopFilter(len);
        System.out.println("Running on " + this.localhostName);
        System.out.println("Average log time for disabled statements: " + avg + " nanos.");
        if (KAL.equals(this.localhostName)) {
            LoggerPerfTest.assertTrue((80.0 > avg ? 1 : 0) != 0);
        }
    }

    double loopBasic(long len) {
        LoggerContext lc = new LoggerContext();
        NOPAppender mopAppender = new NOPAppender();
        mopAppender.start();
        Logger logger = lc.getLogger(((Object)((Object)this)).getClass());
        logger.setLevel(Level.OFF);
        long start = System.nanoTime();
        for (long i = 0L; i < len; ++i) {
            logger.debug("Toto");
        }
        long end = System.nanoTime();
        return (end - start) / len;
    }

    double loopNopFilter(long len) {
        LoggerContext lc = new LoggerContext();
        NOPAppender mopAppender = new NOPAppender();
        NOPTurboFilter nopFilter = new NOPTurboFilter();
        nopFilter.setName("nop");
        mopAppender.start();
        lc.addTurboFilter((TurboFilter)nopFilter);
        Logger logger = lc.getLogger(((Object)((Object)this)).getClass());
        logger.setLevel(Level.OFF);
        long start = System.nanoTime();
        for (long i = 0L; i < len; ++i) {
            logger.debug("Toto");
        }
        long end = System.nanoTime();
        return (end - start) / len;
    }
}

