/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.net.JMSTopicAppender;
import ch.qos.logback.classic.net.mock.MockInitialContext;
import ch.qos.logback.classic.net.mock.MockInitialContextFactory;
import ch.qos.logback.classic.net.mock.MockTopic;
import ch.qos.logback.classic.net.mock.MockTopicConnectionFactory;
import ch.qos.logback.classic.net.mock.MockTopicPublisher;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import java.util.Properties;
import javax.jms.ObjectMessage;
import junit.framework.TestCase;

public class JMSTopicAppenderTest
extends TestCase {
    Context context;
    JMSTopicAppender appender;

    protected void setUp() throws Exception {
        this.context = new ContextBase();
        this.appender = new JMSTopicAppender();
        this.appender.setContext(this.context);
        this.appender.setName("jmsTopic");
        this.appender.tcfBindingName = "topicCnxFactory";
        this.appender.topicBindingName = "testTopic";
        this.appender.setProviderURL("url");
        this.appender.setInitialContextFactoryName(MockInitialContextFactory.class.getName());
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put(this.appender.tcfBindingName, new MockTopicConnectionFactory());
        mic.map.put(this.appender.topicBindingName, new MockTopic(this.appender.topicBindingName));
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.appender = null;
        this.context = null;
        super.tearDown();
    }

    public void testAppendOk() {
        this.appender.start();
        LoggingEvent le = this.createLoggingEvent();
        this.appender.append(le);
        MockTopicPublisher tp = (MockTopicPublisher)this.appender.topicPublisher;
        JMSTopicAppenderTest.assertEquals((int)1, (int)tp.getMessageList().size());
        ObjectMessage message = (ObjectMessage)tp.getMessageList().get(0);
        try {
            JMSTopicAppenderTest.assertEquals((Object)le, (Object)message.getObject());
        }
        catch (Exception e) {
            JMSTopicAppenderTest.fail();
        }
    }

    public void testAppendFailure() {
        this.appender.start();
        this.appender.topicPublisher = null;
        LoggingEvent le = this.createLoggingEvent();
        for (int i = 1; i <= 3; ++i) {
            this.appender.append(le);
            JMSTopicAppenderTest.assertEquals((int)i, (int)this.context.getStatusManager().getCount());
            JMSTopicAppenderTest.assertTrue((boolean)this.appender.isStarted());
        }
        this.appender.append(le);
        JMSTopicAppenderTest.assertEquals((int)4, (int)this.context.getStatusManager().getCount());
        JMSTopicAppenderTest.assertFalse((boolean)this.appender.isStarted());
    }

    public void testBuildEnvProperties() {
        this.appender.setInitialContextFactoryName("icfn");
        this.appender.setProviderURL("url");
        this.appender.setURLPkgPrefixes("pkgPref");
        this.appender.setSecurityPrincipalName("user");
        this.appender.setSecurityCredentials("cred");
        Properties props = this.appender.buildEnvProperties();
        JMSTopicAppenderTest.assertEquals((int)5, (int)props.size());
        JMSTopicAppenderTest.assertEquals((String)this.appender.getInitialContextFactoryName(), (String)props.getProperty("java.naming.factory.initial"));
        JMSTopicAppenderTest.assertEquals((String)this.appender.getProviderURL(), (String)props.getProperty("java.naming.provider.url"));
        JMSTopicAppenderTest.assertEquals((String)this.appender.getURLPkgPrefixes(), (String)props.getProperty("java.naming.factory.url.pkgs"));
        JMSTopicAppenderTest.assertEquals((String)this.appender.getSecurityPrincipalName(), (String)props.getProperty("java.naming.security.principal"));
        JMSTopicAppenderTest.assertEquals((String)this.appender.getSecurityCredentials(), (String)props.getProperty("java.naming.security.credentials"));
    }

    public void testBuildEnvPropertiesWithNullProviderURL() {
        this.appender.setInitialContextFactoryName("icfn");
        this.appender.setProviderURL(null);
        this.appender.setURLPkgPrefixes("pkgPref");
        this.appender.setSecurityPrincipalName("user");
        this.appender.setSecurityCredentials("cred");
        Properties props = this.appender.buildEnvProperties();
        JMSTopicAppenderTest.assertEquals((int)4, (int)props.size());
        JMSTopicAppenderTest.assertEquals((String)this.appender.getInitialContextFactoryName(), (String)props.getProperty("java.naming.factory.initial"));
        JMSTopicAppenderTest.assertEquals(null, (String)props.getProperty("java.naming.provider.url"));
        JMSTopicAppenderTest.assertEquals((String)this.appender.getURLPkgPrefixes(), (String)props.getProperty("java.naming.factory.url.pkgs"));
        JMSTopicAppenderTest.assertEquals((String)this.appender.getSecurityPrincipalName(), (String)props.getProperty("java.naming.security.principal"));
        JMSTopicAppenderTest.assertEquals((String)this.appender.getSecurityCredentials(), (String)props.getProperty("java.naming.security.credentials"));
        JMSTopicAppenderTest.assertEquals((int)1, (int)this.context.getStatusManager().getCount());
    }

    public void testBuildEnvPropertiesWithNullCredentials() {
        this.appender.setInitialContextFactoryName("icfn");
        this.appender.setProviderURL("url");
        this.appender.setURLPkgPrefixes("pkgPref");
        this.appender.setSecurityPrincipalName("user");
        this.appender.setSecurityCredentials(null);
        Properties props = this.appender.buildEnvProperties();
        JMSTopicAppenderTest.assertEquals((int)4, (int)props.size());
        JMSTopicAppenderTest.assertEquals((String)this.appender.getInitialContextFactoryName(), (String)props.getProperty("java.naming.factory.initial"));
        JMSTopicAppenderTest.assertEquals((String)this.appender.getProviderURL(), (String)props.getProperty("java.naming.provider.url"));
        JMSTopicAppenderTest.assertEquals((String)this.appender.getURLPkgPrefixes(), (String)props.getProperty("java.naming.factory.url.pkgs"));
        JMSTopicAppenderTest.assertEquals((String)this.appender.getSecurityPrincipalName(), (String)props.getProperty("java.naming.security.principal"));
        JMSTopicAppenderTest.assertEquals(null, (String)props.getProperty("java.naming.security.credentials"));
        JMSTopicAppenderTest.assertEquals((int)1, (int)this.context.getStatusManager().getCount());
    }

    public void testBuildEnvPropertiesWithPkgNull() {
        this.appender.setInitialContextFactoryName("icfn");
        this.appender.setProviderURL("url");
        this.appender.setURLPkgPrefixes(null);
        this.appender.setSecurityPrincipalName("user");
        this.appender.setSecurityCredentials("cred");
        Properties props = this.appender.buildEnvProperties();
        JMSTopicAppenderTest.assertEquals((int)4, (int)props.size());
        JMSTopicAppenderTest.assertEquals((String)this.appender.getInitialContextFactoryName(), (String)props.getProperty("java.naming.factory.initial"));
        JMSTopicAppenderTest.assertEquals((String)this.appender.getProviderURL(), (String)props.getProperty("java.naming.provider.url"));
        JMSTopicAppenderTest.assertEquals(null, (String)props.getProperty("java.naming.factory.url.pkgs"));
        JMSTopicAppenderTest.assertEquals((String)this.appender.getSecurityPrincipalName(), (String)props.getProperty("java.naming.security.principal"));
        JMSTopicAppenderTest.assertEquals((String)this.appender.getSecurityCredentials(), (String)props.getProperty("java.naming.security.credentials"));
        JMSTopicAppenderTest.assertEquals((int)0, (int)this.context.getStatusManager().getCount());
    }

    public void testStartMinimalInfo() {
        this.appender.setProviderURL(null);
        this.appender.start();
        JMSTopicAppenderTest.assertTrue((boolean)this.appender.isStarted());
        try {
            JMSTopicAppenderTest.assertEquals((String)this.appender.topicBindingName, (String)this.appender.topicPublisher.getTopic().getTopicName());
        }
        catch (Exception e) {
            JMSTopicAppenderTest.fail();
        }
    }

    public void testStartUserPass() {
        this.appender.setUserName("test");
        this.appender.setPassword("test");
        this.appender.start();
        JMSTopicAppenderTest.assertTrue((boolean)this.appender.isStarted());
        try {
            JMSTopicAppenderTest.assertEquals((String)this.appender.topicBindingName, (String)this.appender.topicPublisher.getTopic().getTopicName());
        }
        catch (Exception e) {
            JMSTopicAppenderTest.fail();
        }
    }

    public void testStartFails() {
        this.appender.topicBindingName = null;
        this.appender.start();
        JMSTopicAppenderTest.assertFalse((boolean)this.appender.isStarted());
    }

    private LoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent();
        le.setLevel(Level.DEBUG);
        le.setMessage("test message");
        le.setTimeStamp(System.currentTimeMillis());
        le.setThreadName(Thread.currentThread().getName());
        return le;
    }
}

