/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.ConverterTest;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.FormattingConverter;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.pattern.parser.AbstractPatternLayoutBaseTest;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PatternLayoutTest
extends AbstractPatternLayoutBaseTest {
    private PatternLayout pl = new PatternLayout();
    private LoggerContext lc = new LoggerContext();
    Logger logger = this.lc.getLogger(ConverterTest.class);
    LoggingEvent le;
    List optionList = new ArrayList();

    public PatternLayoutTest() {
        Exception ex = new Exception("Bogus exception");
        this.le = this.makeLoggingEvent(ex);
    }

    @Before
    public void setUp() {
        this.pl.setContext((Context)this.lc);
    }

    LoggingEvent makeLoggingEvent(Exception ex) {
        return new LoggingEvent(FormattingConverter.class.getName(), this.logger, Level.INFO, "Some message", (Throwable)ex, null);
    }

    public LoggingEvent getEventObject() {
        return this.makeLoggingEvent(null);
    }

    public PatternLayoutBase getPatternLayoutBase() {
        return new PatternLayout();
    }

    @Test
    public void testOK() {
        this.pl.setPattern("%d %le [%t] %lo{30} - %m%n");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        String regex = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} INFO \\[[mM]ain(\\sThread)?\\] c.q.l.c.pattern.ConverterTest - Some message\\s*";
        Assert.assertTrue((boolean)val.matches(regex));
    }

    @Test
    public void testNoExeptionHandler() {
        this.pl.setPattern("%m%n");
        this.pl.start();
        String val = this.pl.doLayout(this.le);
        Assert.assertTrue((boolean)val.contains("java.lang.Exception: Bogus exception"));
    }

    @Test
    public void testCompositePattern() {
        this.pl.setPattern("%-56(%d %lo{20}) - %m%n");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        String regex = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} c.q.l.c.p.ConverterTest          - Some message\\s*";
        Assert.assertTrue((boolean)val.matches(regex));
    }

    @Test
    public void testNopExeptionHandler() {
        this.pl.setPattern("%nopex %m%n");
        this.pl.start();
        String val = this.pl.doLayout(this.le);
        Assert.assertTrue((!val.contains("java.lang.Exception: Bogus exception") ? 1 : 0) != 0);
    }

    @Test
    public void testWithParenthesis() {
        this.pl.setPattern("\\(%msg:%msg\\) %msg");
        this.pl.start();
        this.le = this.makeLoggingEvent(null);
        String val = this.pl.doLayout(this.le);
        Assert.assertEquals((Object)"(Some message:Some message) Some message", (Object)val);
    }

    @Test
    public void testWithLettersComingFromLog4j() {
        this.pl.setPattern("%d %p [%t] %c{30} - %m%n");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        String regex = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} INFO \\[[mM]ain(\\sThread)?\\] c.q.l.c.pattern.ConverterTest - Some message\\s*";
        Assert.assertTrue((boolean)val.matches(regex));
    }

    @Test
    public void contextNameTest() {
        this.pl.setPattern("%contextName");
        this.lc.setName("aValue");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        Assert.assertEquals((Object)"aValue", (Object)val);
    }

    public Context getContext() {
        return this.lc;
    }
}

