/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.testUtil.Env;
import ch.qos.logback.core.util.StatusPrinter;
import java.net.InetAddress;
import java.util.Random;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.MDC;

public class DBAppenderIntegrationTest {
    static String LOCAL_HOST_NAME;
    static String[] CONFORMING_HOST_LIST;
    int diff = new Random(System.nanoTime()).nextInt(10000);
    LoggerContext lc = new LoggerContext();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        InetAddress localhostIA = InetAddress.getLocalHost();
        LOCAL_HOST_NAME = localhostIA.getHostName();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.lc.setName("lc" + this.diff);
    }

    @After
    public void tearDown() throws Exception {
        this.lc.stop();
    }

    public void doTest(String configFile) throws JoranException {
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)this.lc);
        configurator.doConfigure(configFile);
        Logger logger = this.lc.getLogger(DBAppenderIntegrationTest.class);
        MDC.put((String)"userid", (String)("user" + this.diff));
        int runLength = 5;
        for (int i = 1; i <= runLength; ++i) {
            logger.debug("This is a debug message. Message number: " + i);
        }
        logger.error("At last an error.", (Throwable)new Exception("Just testing"));
        StatusPrinter.print((Context)this.lc);
        Assert.assertEquals((long)0L, (long)this.lc.getStatusManager().getLevel());
    }

    static boolean isConformingHostAndJDK16OrHigher() {
        if (!Env.isJDK6OrHigher()) {
            return false;
        }
        for (String conformingHost : CONFORMING_HOST_LIST) {
            if (!conformingHost.equalsIgnoreCase(LOCAL_HOST_NAME)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void sqlserver() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher()) {
            return;
        }
        this.doTest("src/test/input/integration/db/sqlserver-with-driver.xml");
    }

    @Test
    public void oracle10g() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher()) {
            return;
        }
        this.doTest("src/test/input/integration/db/oracle10g-with-driver.xml");
    }

    @Test
    @Ignore
    public void oracle11g() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher()) {
            return;
        }
        this.doTest("src/test/input/integration/db/oracle11g-with-driver.xml");
    }

    @Test
    public void mysql() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher()) {
            return;
        }
        this.doTest("src/test/input/integration/db/mysql-with-driver.xml");
    }

    @Test
    public void postgres() throws Exception {
        if (!DBAppenderIntegrationTest.isConformingHostAndJDK16OrHigher()) {
            return;
        }
        this.doTest("src/test/input/integration/db/postgresql-with-driver.xml");
    }

    static {
        CONFORMING_HOST_LIST = new String[]{"Orion"};
    }
}

