/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.html;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.html.DefaultThrowableRenderer;
import ch.qos.logback.classic.html.HTMLLayout;
import ch.qos.logback.classic.html.XHTMLEntityResolver;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableDataPoint;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.html.IThrowableRenderer;
import ch.qos.logback.core.read.ListAppender;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.xml.sax.EntityResolver;

public class HTMLLayoutTest {
    LoggerContext lc;
    Logger logger;
    HTMLLayout layout;

    @Before
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.lc.setName("default");
        ListAppender appender = new ListAppender();
        appender.setContext((Context)this.lc);
        this.layout = new HTMLLayout();
        this.layout.setThrowableRenderer((IThrowableRenderer)new DefaultThrowableRenderer());
        this.layout.setContext((Context)this.lc);
        this.layout.setPattern("%level%thread%msg");
        this.layout.start();
        appender.setLayout((Layout)this.layout);
        this.logger = this.lc.getLogger("root");
        this.logger.addAppender((Appender)appender);
        appender.start();
    }

    @After
    public void tearDown() throws Exception {
        this.lc = null;
        this.layout = null;
    }

    @Test
    public void testHeader() throws Exception {
        String header = this.layout.getFileHeader();
        Document doc = this.parseOutput(header + "</body></html>");
        Element rootElement = doc.getRootElement();
        Assert.assertNotNull((Object)rootElement.element("body"));
    }

    @Test
    public void testPresentationHeader() throws Exception {
        String header = this.layout.getFileHeader();
        String presentationHeader = this.layout.getPresentationHeader();
        header = header + presentationHeader;
        Document doc = this.parseOutput(header + "</table></body></html>");
        Element rootElement = doc.getRootElement();
        Element bodyElement = rootElement.element("body");
        Element tableElement = bodyElement.element("table");
        Element trElement = tableElement.element("tr");
        List elementList = trElement.elements();
        Assert.assertEquals((Object)"Level", (Object)((Element)elementList.get(0)).getText());
        Assert.assertEquals((Object)"Thread", (Object)((Element)elementList.get(1)).getText());
        Assert.assertEquals((Object)"Message", (Object)((Element)elementList.get(2)).getText());
    }

    @Test
    public void testAppendThrowable() throws Exception {
        StringBuilder buf = new StringBuilder();
        ThrowableDataPoint[] strArray = new ThrowableDataPoint[]{new ThrowableDataPoint("test1"), new ThrowableDataPoint("test2")};
        DefaultThrowableRenderer renderer = (DefaultThrowableRenderer)this.layout.getThrowableRenderer();
        renderer.render(buf, strArray);
        String[] result = buf.toString().split(CoreConstants.LINE_SEPARATOR);
        Assert.assertEquals((Object)"<tr><td class=\"Exception\" colspan=\"6\">test1", (Object)result[0]);
        Assert.assertEquals((Object)"<br />&nbsp;&nbsp;&nbsp;&nbsp;test2", (Object)result[1]);
    }

    @Test
    public void testDoLayout() throws Exception {
        LoggingEvent le = this.createLoggingEvent();
        String result = this.layout.getFileHeader();
        result = result + this.layout.getPresentationHeader();
        result = result + this.layout.doLayout(le);
        result = result + this.layout.getPresentationFooter();
        result = result + this.layout.getFileFooter();
        Document doc = this.parseOutput(result);
        Element rootElement = doc.getRootElement();
        rootElement.toString();
        Assert.assertEquals((long)2L, (long)rootElement.elements().size());
        Element bodyElement = (Element)rootElement.elements().get(1);
        Element tableElement = (Element)bodyElement.elements().get(3);
        Assert.assertEquals((Object)"table", (Object)tableElement.getName());
        Element trElement = (Element)tableElement.elements().get(1);
        Element tdElement = (Element)trElement.elements().get(0);
        Assert.assertEquals((Object)"DEBUG", (Object)tdElement.getText());
        tdElement = (Element)trElement.elements().get(1);
        String regex = "[mM]ain(\\sThread)?";
        Assert.assertTrue((boolean)tdElement.getText().toString().matches(regex));
        tdElement = (Element)trElement.elements().get(2);
        Assert.assertEquals((Object)"test message", (Object)tdElement.getText());
    }

    @Test
    public void layoutWithException() throws Exception {
        this.layout.setPattern("%level %thread %msg %ex");
        LoggingEvent le = this.createLoggingEvent();
        le.setThrowableProxy(new ThrowableProxy((Throwable)new Exception("test Exception")));
        String result = this.layout.doLayout(le);
        String stringToParse = this.layout.getFileHeader();
        stringToParse = stringToParse + this.layout.getPresentationHeader();
        stringToParse = stringToParse + result;
        stringToParse = stringToParse + "</table></body></html>";
        Document doc = this.parseOutput(stringToParse);
        Element rootElement = doc.getRootElement();
        Element bodyElement = rootElement.element("body");
        Element tableElement = bodyElement.element("table");
        List trElementList = tableElement.elements();
        Element exceptionRowElement = (Element)trElementList.get(2);
        Element exceptionElement = exceptionRowElement.element("td");
        Assert.assertEquals((long)3L, (long)tableElement.elements().size());
        Assert.assertTrue((boolean)exceptionElement.getText().contains("java.lang.Exception: test Exception"));
    }

    @Test
    @Ignore
    public void rawLimit() throws Exception {
        StringBuilder sb = new StringBuilder();
        String header = this.layout.getFileHeader();
        Assert.assertTrue((boolean)header.startsWith("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">"));
        sb.append(header);
        sb.append(this.layout.getPresentationHeader());
        for (int i = 0; i < 30000; ++i) {
            sb.append(this.layout.doLayout(new LoggingEvent(this.getClass().getName(), this.logger, Level.DEBUG, "test message" + i, null, null)));
        }
        sb.append(this.layout.getPresentationFooter());
        sb.append(this.layout.getFileFooter());
        this.parseOutput(sb.toString());
    }

    private LoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent(this.getClass().getName(), this.logger, Level.DEBUG, "test message", null, null);
        return le;
    }

    Document parseOutput(String output) throws Exception {
        XHTMLEntityResolver resolver = new XHTMLEntityResolver();
        SAXReader reader = new SAXReader();
        reader.setValidation(true);
        reader.setEntityResolver((EntityResolver)resolver);
        return reader.read((InputStream)new ByteArrayInputStream(output.getBytes()));
    }
}

