/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.StringListAppender;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.turbo.DebugUsersTurboFilter;
import ch.qos.logback.classic.turbo.NOPTurboFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.util.StatusPrinter;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.MDC;

public class JoranConfiguratorTest {
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(this.getClass().getName());
    Logger root = this.loggerContext.getLogger("root");

    void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(file);
    }

    @Test
    public void testSimpleList() throws JoranException {
        this.configure("src/test/input/joran/simpleList.xml");
        Logger logger = this.loggerContext.getLogger(this.getClass().getName());
        Logger root = this.loggerContext.getLogger("root");
        ListAppender listAppender = (ListAppender)root.getAppender("LIST");
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        String msg = "hello world";
        logger.debug(msg);
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        LoggingEvent le = (LoggingEvent)listAppender.list.get(0);
        Assert.assertEquals((Object)msg, (Object)le.getMessage());
    }

    @Test
    public void testLevel() throws JoranException {
        this.configure("src/test/input/joran/simpleLevel.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        String msg = "hello world";
        this.logger.debug(msg);
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
    }

    @Test
    public void testRootLoggerLevelSettingBySystemProperty() throws JoranException {
        String propertyName = "logback.level";
        System.setProperty(propertyName, "INFO");
        this.configure("src/test/input/joran/rootLevelByProperty.xml");
        StatusPrinter.print((Context)this.loggerContext);
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        String msg = "hello world";
        this.logger.debug(msg);
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        System.clearProperty(propertyName);
    }

    @Test
    public void testLoggerLevelSettingBySystemProperty() throws JoranException {
        String propertyName = "logback.level";
        System.setProperty(propertyName, "DEBUG");
        this.configure("src/test/input/joran/loggerLevelByProperty.xml");
        StatusPrinter.print((Context)this.loggerContext);
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        String msg = "hello world";
        this.logger.debug(msg);
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        System.clearProperty(propertyName);
    }

    @Test
    public void testStatusListener() throws JoranException {
        this.configure("src/test/input/joran/statusListener.xml");
        StatusPrinter.print((Context)this.loggerContext);
    }

    @Test
    public void contextRename() throws JoranException {
        this.loggerContext.setName("default");
        this.configure("src/test/input/joran/contextRename.xml");
        Assert.assertEquals((Object)"wombat", (Object)this.loggerContext.getName());
    }

    @Test
    public void testEval() throws JoranException {
        this.configure("src/test/input/joran/callerData.xml");
        String msg = "hello world";
        this.logger.debug("toto");
        this.logger.debug(msg);
        StringListAppender slAppender = (StringListAppender)this.loggerContext.getLogger("root").getAppender("STR_LIST");
        Assert.assertNotNull((Object)((Object)slAppender));
        Assert.assertEquals((long)2L, (long)slAppender.strList.size());
        Assert.assertTrue((boolean)slAppender.strList.get(0).contains(" DEBUG - toto"));
        String str1 = slAppender.strList.get(1);
        Assert.assertTrue((boolean)str1.contains("Caller+0"));
        Assert.assertTrue((boolean)str1.contains(" DEBUG - hello world"));
    }

    @Test
    public void testTurboFilter() throws JoranException {
        this.configure("src/test/input/joran/turbo.xml");
        TurboFilter filter = (TurboFilter)this.loggerContext.getTurboFilterList().get(0);
        Assert.assertTrue((boolean)(filter instanceof NOPTurboFilter));
    }

    @Test
    public void testTurboFilterWithStringList() throws JoranException {
        this.configure("src/test/input/joran/turbo2.xml");
        TurboFilter filter = (TurboFilter)this.loggerContext.getTurboFilterList().get(0);
        Assert.assertTrue((boolean)(filter instanceof DebugUsersTurboFilter));
        DebugUsersTurboFilter dutf = (DebugUsersTurboFilter)filter;
        Assert.assertEquals((long)2L, (long)dutf.getUsers().size());
    }

    @Test
    public void testLevelFilter() throws JoranException {
        this.configure("src/test/input/joran/levelFilter.xml");
        StatusPrinter.print((Context)this.loggerContext);
        this.logger.warn("hello");
        this.logger.error("to be ignored");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertNotNull((Object)listAppender);
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        LoggingEvent back = (LoggingEvent)listAppender.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)back.getLevel());
        Assert.assertEquals((Object)"hello", (Object)back.getMessage());
    }

    @Test
    public void testEvaluatorFilter() throws JoranException {
        this.configure("src/test/input/joran/evaluatorFilter.xml");
        StatusPrinter.print((Context)this.loggerContext);
        this.logger.warn("hello");
        this.logger.error("to be ignored");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertNotNull((Object)listAppender);
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        LoggingEvent back = (LoggingEvent)listAppender.list.get(0);
        Assert.assertEquals((Object)Level.WARN, (Object)back.getLevel());
        Assert.assertEquals((Object)"hello", (Object)back.getMessage());
    }

    @Test
    public void testTurboDynamicThreshold() throws JoranException {
        this.configure("src/test/input/joran/turboDynamicThreshold.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        MDC.put((String)"userId", (String)"user1");
        this.logger.debug("hello user1");
        MDC.put((String)"userId", (String)"user2");
        this.logger.debug("hello user2");
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
        LoggingEvent le = (LoggingEvent)listAppender.list.get(0);
        Assert.assertEquals((Object)"hello user2", (Object)le.getMessage());
    }

    @Test
    public void testTurboDynamicThreshold2() throws JoranException {
        this.configure("src/test/input/joran/turboDynamicThreshold2.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        MDC.put((String)"userId", (String)"user1");
        this.logger.debug("hello user1");
        MDC.put((String)"userId", (String)"user2");
        this.logger.debug("hello user2");
        MDC.put((String)"userId", (String)"user3");
        this.logger.debug("hello user3");
        Assert.assertEquals((long)2L, (long)listAppender.list.size());
        LoggingEvent le = (LoggingEvent)listAppender.list.get(0);
        Assert.assertEquals((Object)"hello user1", (Object)le.getMessage());
        le = (LoggingEvent)listAppender.list.get(1);
        Assert.assertEquals((Object)"hello user2", (Object)le.getMessage());
    }
}

