/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.html.HTMLLayout;
import ch.qos.logback.classic.html.XHTMLEntityResolver;
import ch.qos.logback.classic.net.SMTPAppender;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Random;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.dom4j.io.SAXReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.auth.LoginAuthenticationHandler;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.PlainAuthenticationHandler;
import org.subethamail.smtp.auth.PluginAuthenticationHandler;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.server.MessageListenerAdapter;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPAppender_SubethaSMTPTest {
    int diff = 1024 + new Random().nextInt(10000);
    Wiser wiser;
    SMTPAppender smtpAppender;
    LoggerContext lc = new LoggerContext();
    static final String TEST_SUBJECT = "test subject";
    static final String HEADER = "HEADER\n";
    static final String FOOTER = "FOOTER\n";

    @Before
    public void setUp() throws Exception {
        this.wiser = new Wiser();
        this.wiser.setPort(this.diff);
        this.wiser.getServer();
        this.wiser.start();
        this.buildSMTPAppender();
    }

    void buildSMTPAppender() throws Exception {
        this.smtpAppender = new SMTPAppender();
        this.smtpAppender.setContext((Context)this.lc);
        this.smtpAppender.setName("smtp");
        this.smtpAppender.setFrom("user@host.dom");
        this.smtpAppender.setSMTPHost("localhost");
        this.smtpAppender.setSMTPPort(this.diff);
        this.smtpAppender.setSubject(TEST_SUBJECT);
        this.smtpAppender.addTo("noreply@qos.ch");
    }

    private Layout<LoggingEvent> buildPatternLayout(LoggerContext lc) {
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)lc);
        layout.setFileHeader(HEADER);
        layout.setPattern("%-4relative [%thread] %-5level %logger %class - %msg%n");
        layout.setFileFooter(FOOTER);
        layout.start();
        return layout;
    }

    private Layout<LoggingEvent> buildHTMLLayout(LoggerContext lc) {
        HTMLLayout layout = new HTMLLayout();
        layout.setContext((Context)lc);
        layout.setPattern("%level%class%msg");
        layout.start();
        return layout;
    }

    @After
    public void tearDown() throws Exception {
    }

    private static String getWholeMessage(Part msg) {
        try {
            ByteArrayOutputStream bodyOut = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)bodyOut);
            return bodyOut.toString("US-ASCII").trim();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getBody(Part msg) {
        String all = SMTPAppender_SubethaSMTPTest.getWholeMessage(msg);
        int i = all.indexOf("\r\n\r\n");
        return all.substring(i + 4, all.length());
    }

    @Test
    public void smoke() throws Exception {
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc));
        this.smtpAppender.start();
        Logger logger = this.lc.getLogger("test");
        logger.addAppender((Appender)this.smtpAppender);
        logger.debug("hello");
        logger.error("en error", (Throwable)new Exception("an exception"));
        List wiserMsgList = this.wiser.getMessages();
        Assert.assertNotNull((Object)wiserMsgList);
        Assert.assertEquals((long)1L, (long)wiserMsgList.size());
        WiserMessage wm = (WiserMessage)wiserMsgList.get(0);
        MimeMessage mm = wm.getMimeMessage();
        Assert.assertEquals((Object)TEST_SUBJECT, (Object)mm.getSubject());
        MimeMultipart mp = (MimeMultipart)mm.getContent();
        String body = SMTPAppender_SubethaSMTPTest.getBody((Part)mp.getBodyPart(0));
        System.out.println("[" + body);
        Assert.assertTrue((boolean)body.startsWith(HEADER.trim()));
        Assert.assertTrue((boolean)body.endsWith(FOOTER.trim()));
    }

    @Test
    public void html() throws Exception {
        this.smtpAppender.setLayout(this.buildHTMLLayout(this.lc));
        this.smtpAppender.start();
        Logger logger = this.lc.getLogger("test");
        logger.addAppender((Appender)this.smtpAppender);
        logger.debug("hello");
        logger.error("en error", (Throwable)new Exception("an exception"));
        List wiserMsgList = this.wiser.getMessages();
        Assert.assertNotNull((Object)wiserMsgList);
        Assert.assertEquals((long)1L, (long)wiserMsgList.size());
        WiserMessage wm = (WiserMessage)wiserMsgList.get(0);
        MimeMessage mm = wm.getMimeMessage();
        Assert.assertEquals((Object)TEST_SUBJECT, (Object)mm.getSubject());
        MimeMultipart mp = (MimeMultipart)mm.getContent();
        SAXReader reader = new SAXReader();
        reader.setValidation(true);
        reader.setEntityResolver((EntityResolver)new XHTMLEntityResolver());
        reader.read(mp.getBodyPart(0).getInputStream());
    }

    @Test
    public void htmlLong() throws Exception {
        this.smtpAppender.setLayout(this.buildHTMLLayout(this.lc));
        this.smtpAppender.start();
        Logger logger = this.lc.getLogger("test");
        logger.addAppender((Appender)this.smtpAppender);
        for (int i = 0; i < 30000; ++i) {
            logger.debug("hello " + i);
        }
        logger.error("en error", (Throwable)new Exception("an exception"));
        List wiserMsgList = this.wiser.getMessages();
        Assert.assertNotNull((Object)wiserMsgList);
        Assert.assertEquals((long)1L, (long)wiserMsgList.size());
        WiserMessage wm = (WiserMessage)wiserMsgList.get(0);
        MimeMessage mm = wm.getMimeMessage();
        Assert.assertEquals((Object)TEST_SUBJECT, (Object)mm.getSubject());
        MimeMultipart mp = (MimeMultipart)mm.getContent();
        SAXReader reader = new SAXReader();
        reader.setValidation(true);
        reader.setEntityResolver((EntityResolver)new XHTMLEntityResolver());
        reader.read(mp.getBodyPart(0).getInputStream());
    }

    @Test
    public void authenticated() throws Exception {
        MessageListenerAdapter mla = (MessageListenerAdapter)this.wiser.getServer().getMessageHandlerFactory();
        mla.setAuthenticationHandlerFactory((AuthenticationHandlerFactory)new TrivialAuthHandlerFactory());
        this.smtpAppender.setUsername("x");
        this.smtpAppender.setPassword("x");
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc));
        this.smtpAppender.start();
        Logger logger = this.lc.getLogger("test");
        logger.addAppender((Appender)this.smtpAppender);
        logger.debug("hello");
        logger.error("en error", (Throwable)new Exception("an exception"));
        List wiserMsgList = this.wiser.getMessages();
        Assert.assertNotNull((Object)wiserMsgList);
        Assert.assertEquals((long)1L, (long)wiserMsgList.size());
        WiserMessage wm = (WiserMessage)wiserMsgList.get(0);
        MimeMessage mm = wm.getMimeMessage();
        Assert.assertEquals((Object)TEST_SUBJECT, (Object)mm.getSubject());
        MimeMultipart mp = (MimeMultipart)mm.getContent();
        String body = SMTPAppender_SubethaSMTPTest.getBody((Part)mp.getBodyPart(0));
        Assert.assertTrue((boolean)body.startsWith(HEADER.trim()));
        Assert.assertTrue((boolean)body.endsWith(FOOTER.trim()));
    }

    @Test
    @Ignore
    public void authenticatedSSL() throws Exception {
        MessageListenerAdapter mla = (MessageListenerAdapter)this.wiser.getServer().getMessageHandlerFactory();
        mla.setAuthenticationHandlerFactory((AuthenticationHandlerFactory)new TrivialAuthHandlerFactory());
        this.smtpAppender.setSTARTTLS(true);
        this.smtpAppender.setUsername("xx");
        this.smtpAppender.setPassword("xx");
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc));
        this.smtpAppender.start();
        Logger logger = this.lc.getLogger("test");
        logger.addAppender((Appender)this.smtpAppender);
        logger.debug("hello");
        logger.error("en error", (Throwable)new Exception("an exception"));
        StatusPrinter.print((Context)this.lc);
        List wiserMsgList = this.wiser.getMessages();
        Assert.assertNotNull((Object)wiserMsgList);
        Assert.assertEquals((long)1L, (long)wiserMsgList.size());
    }

    @Test
    @Ignore
    public void authenticatedGmailStartTLS() throws Exception {
        this.smtpAppender.setSMTPHost("smtp.gmail.com");
        this.smtpAppender.setSMTPPort(587);
        this.smtpAppender.addTo("XXX@gmail.com");
        this.smtpAppender.setSTARTTLS(true);
        this.smtpAppender.setUsername("XXX@gmail.com");
        this.smtpAppender.setPassword("XXX");
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc));
        this.smtpAppender.start();
        Logger logger = this.lc.getLogger("authenticatedGmailSTARTTLS");
        logger.addAppender((Appender)this.smtpAppender);
        logger.debug("hello");
        logger.error("en error", (Throwable)new Exception("an exception"));
        StatusPrinter.print((Context)this.lc);
    }

    @Test
    @Ignore
    public void authenticatedGmail_SSL() throws Exception {
        this.smtpAppender.setSMTPHost("smtp.gmail.com");
        this.smtpAppender.setSMTPPort(465);
        this.smtpAppender.addTo("XXX@gmail.com");
        this.smtpAppender.setSSL(true);
        this.smtpAppender.setUsername("XXX@gmail.com");
        this.smtpAppender.setPassword("XXX");
        this.smtpAppender.setLayout(this.buildPatternLayout(this.lc));
        this.smtpAppender.start();
        Logger logger = this.lc.getLogger("authenticatedGmail_SSL");
        logger.addAppender((Appender)this.smtpAppender);
        logger.debug("hello");
        logger.error("en error", (Throwable)new Exception("an exception"));
        StatusPrinter.print((Context)this.lc);
    }

    public class TrivialAuthHandlerFactory
    implements AuthenticationHandlerFactory {
        public AuthenticationHandler create() {
            PluginAuthenticationHandler ret = new PluginAuthenticationHandler();
            UsernamePasswordValidator validator = new UsernamePasswordValidator(){

                public void login(String username, String password) throws LoginFailedException {
                    if (!username.equals(password)) {
                        throw new LoginFailedException("username=" + username + ", password=" + password);
                    }
                }
            };
            ret.addPlugin((AuthenticationHandler)new PlainAuthenticationHandler(validator));
            ret.addPlugin((AuthenticationHandler)new LoginAuthenticationHandler(validator));
            return ret;
        }
    }
}

