/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.net.SyslogAppender;
import ch.qos.logback.classic.net.mock.MockSyslogServer;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.testUtil.RandomUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class SyslogAppenderTest {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void basic() throws InterruptedException {
        int port = RandomUtil.getRandomServerPort();
        MockSyslogServer mockServer = new MockSyslogServer(1, port);
        mockServer.start();
        Thread.sleep(100L);
        LoggerContext lc = new LoggerContext();
        lc.setName("test");
        SyslogAppender sa = new SyslogAppender();
        sa.setContext((Context)lc);
        sa.setSyslogHost("localhost");
        sa.setFacility("MAIL");
        sa.setPort(port);
        sa.setSuffixPattern("[%thread] %logger %msg");
        sa.start();
        Assert.assertTrue((boolean)sa.isStarted());
        String loggerName = this.getClass().getName();
        Logger logger = lc.getLogger(loggerName);
        logger.addAppender((Appender)sa);
        String logMsg = "hello";
        logger.debug(logMsg);
        mockServer.join(8000L);
        Assert.assertTrue((boolean)mockServer.isFinished());
        Assert.assertEquals((long)1L, (long)mockServer.getMessageList().size());
        String msg = mockServer.getMessageList().get(0);
        String threadName = Thread.currentThread().getName();
        String expected = "<23>";
        Assert.assertTrue((boolean)msg.startsWith(expected));
        String first = "<\\d{2}>\\w{3} \\d{2} \\d{2}(:\\d{2}){2} [\\w.]* ";
        Assert.assertTrue((boolean)msg.matches(first + "\\[" + threadName + "\\] " + loggerName + " " + logMsg));
    }

    @Test
    public void tException() throws InterruptedException {
        int port = RandomUtil.getRandomServerPort();
        MockSyslogServer mockServer = new MockSyslogServer(21, port);
        mockServer.start();
        Thread.sleep(100L);
        LoggerContext lc = new LoggerContext();
        lc.setName("test");
        SyslogAppender sa = new SyslogAppender();
        sa.setContext((Context)lc);
        sa.setSyslogHost("localhost");
        sa.setFacility("MAIL");
        sa.setPort(port);
        sa.setSuffixPattern("[%thread] %logger %msg");
        sa.start();
        Assert.assertTrue((boolean)sa.isStarted());
        String loggerName = this.getClass().getName();
        Logger logger = lc.getLogger(loggerName);
        logger.addAppender((Appender)sa);
        String logMsg = "hello";
        String exMsg = "just testing";
        Exception ex = new Exception(exMsg);
        logger.debug(logMsg, (Throwable)ex);
        mockServer.join(8000L);
        Assert.assertTrue((boolean)mockServer.isFinished());
        Assert.assertEquals((long)21L, (long)mockServer.getMessageList().size());
        String msg = mockServer.getMessageList().get(0);
        String expected = "<23>";
        Assert.assertTrue((boolean)msg.startsWith(expected));
        String expectedPrefix = "<\\d{2}>\\w{3} \\d{2} \\d{2}(:\\d{2}){2} [\\w.]* ";
        String threadName = Thread.currentThread().getName();
        String expectedResult = expectedPrefix + "\\[" + threadName + "\\] " + loggerName + " " + logMsg;
        Assert.assertTrue((boolean)msg.matches(expectedResult));
    }

    @Test
    public void LBCLASSIC_50() throws JoranException {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        configurator.doConfigure("src/test/input/joran/syslog_LBCLASSIC_50.xml");
        org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.info("hello");
    }
}

