/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.net.NOPOutputStream;
import ch.qos.logback.classic.net.testObjectBuilders.Builder;
import ch.qos.logback.classic.net.testObjectBuilders.LoggingEventWithParametersBuilder;
import ch.qos.logback.classic.net.testObjectBuilders.TrivialLoggingEventBuilder;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.testUtil.Env;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.helpers.BogoPerf;

public class LoggingEventSerializationPerfTest {
    static int LOOP_LEN = 10000;
    NOPOutputStream noos = new NOPOutputStream();
    ObjectOutputStream oos;

    @Before
    public void setUp() throws Exception {
        this.oos = new ObjectOutputStream(this.noos);
    }

    @After
    public void tearDown() throws Exception {
    }

    double doLoop(Builder builder, int loopLen) {
        long start = System.nanoTime();
        int resetCounter = 0;
        for (int i = 0; i < loopLen; ++i) {
            try {
                this.oos.writeObject(builder.build(i));
                this.oos.flush();
                if (++resetCounter < 70) continue;
                this.oos.reset();
                resetCounter = 0;
                continue;
            }
            catch (IOException ex) {
                Assert.fail((String)ex.getMessage());
            }
        }
        long end = System.nanoTime();
        return (double)(end - start) / (1.0 * (double)loopLen);
    }

    @Test
    public void testPerformance() {
        if (Env.isLinux()) {
            return;
        }
        TrivialLoggingEventBuilder builder = new TrivialLoggingEventBuilder();
        this.doLoop(builder, LOOP_LEN);
        this.noos.reset();
        double avg = this.doLoop(builder, LOOP_LEN);
        long actualSize = (long)((double)this.noos.size() / 1126.4);
        double baosSizeLimit = 500.0;
        Assert.assertTrue((String)("baos size" + actualSize + " should be less than " + baosSizeLimit), (baosSizeLimit > (double)actualSize ? 1 : 0) != 0);
        long referencePerf = 5000L;
        BogoPerf.assertDuration((double)avg, (long)referencePerf, (double)CoreConstants.REFERENCE_BIPS);
    }

    @Test
    public void testPerformanceWithParameters() {
        if (Env.isLinux()) {
            return;
        }
        LoggingEventWithParametersBuilder builder = new LoggingEventWithParametersBuilder();
        this.doLoop(builder, LOOP_LEN);
        this.noos.reset();
        double avg = this.doLoop(builder, LOOP_LEN);
        long actualSize = (long)((double)this.noos.size() / 1126.4);
        double baosSizeLimit = 1300.0;
        Assert.assertTrue((String)("actualSize " + actualSize + " should be less than " + baosSizeLimit), (baosSizeLimit > (double)actualSize ? 1 : 0) != 0);
        long referencePerf = 7000L;
        BogoPerf.assertDuration((double)avg, (long)referencePerf, (double)CoreConstants.REFERENCE_BIPS);
    }
}

