/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.status.Status;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class LoggerTest {
    LoggerContext lc = new LoggerContext();
    Logger root = this.lc.getLogger("root");
    Logger loggerTest = this.lc.getLogger(LoggerTest.class);
    ListAppender<LoggingEvent> listAppender = new ListAppender();

    @Test
    public void smoke() {
        ListAppender listAppender = new ListAppender();
        listAppender.start();
        this.root.addAppender((Appender)listAppender);
        Logger logger = this.lc.getLogger(LoggerTest.class);
        Assert.assertEquals((long)0L, (long)listAppender.list.size());
        logger.debug("hello");
        Assert.assertEquals((long)1L, (long)listAppender.list.size());
    }

    @Test
    public void testNoStart() {
        this.listAppender.setContext((Context)this.lc);
        this.root.addAppender(this.listAppender);
        Logger logger = this.lc.getLogger(LoggerTest.class);
        logger.debug("hello");
        List statusList = this.lc.getStatusManager().getCopyOfStatusList();
        Status s0 = (Status)statusList.get(0);
        Assert.assertEquals((long)1L, (long)s0.getLevel());
        Assert.assertTrue((boolean)s0.getMessage().startsWith("Attempted to append to non started"));
    }

    @Test
    public void testAdditive() {
        this.listAppender.start();
        this.root.addAppender(this.listAppender);
        this.loggerTest.addAppender(this.listAppender);
        this.loggerTest.setAdditive(false);
        this.loggerTest.debug("hello");
        Assert.assertEquals((long)1L, (long)this.listAppender.list.size());
    }

    @Test
    public void testRootLogger() {
        Logger logger = (Logger)LoggerFactory.getLogger((String)"root");
        LoggerContext lc = logger.getLoggerContext();
        Assert.assertNotNull((String)"Returned logger is null", (Object)logger);
        Assert.assertEquals((String)"Return logger isn't named root", (Object)logger.getName(), (Object)"root");
        Assert.assertTrue((String)"logger instances should be indentical", (logger == lc.root ? 1 : 0) != 0);
    }

    @Test
    public void testBasicFiltering() throws Exception {
        this.listAppender.start();
        this.root.addAppender(this.listAppender);
        this.root.setLevel(Level.INFO);
        this.loggerTest.debug("x");
        Assert.assertEquals((long)0L, (long)this.listAppender.list.size());
        this.loggerTest.info("x");
        this.loggerTest.warn("x");
        this.loggerTest.error("x");
        Assert.assertEquals((long)3L, (long)this.listAppender.list.size());
    }

    void checkLevelThreshold(Logger logger, Level threshold) {
        if (40000 >= threshold.levelInt) {
            Assert.assertTrue((boolean)logger.isErrorEnabled());
            Assert.assertTrue((boolean)logger.isEnabledFor(Level.ERROR));
        } else {
            Assert.assertFalse((boolean)logger.isErrorEnabled());
            Assert.assertFalse((boolean)logger.isEnabledFor(Level.ERROR));
        }
        if (30000 >= threshold.levelInt) {
            Assert.assertTrue((boolean)logger.isWarnEnabled());
            Assert.assertTrue((boolean)logger.isEnabledFor(Level.WARN));
        } else {
            Assert.assertFalse((boolean)logger.isWarnEnabled());
            Assert.assertFalse((boolean)logger.isEnabledFor(Level.WARN));
        }
        if (20000 >= threshold.levelInt) {
            Assert.assertTrue((boolean)logger.isInfoEnabled());
            Assert.assertTrue((boolean)logger.isEnabledFor(Level.INFO));
        } else {
            Assert.assertFalse((boolean)logger.isInfoEnabled());
            Assert.assertFalse((boolean)logger.isEnabledFor(Level.INFO));
        }
        if (10000 >= threshold.levelInt) {
            Assert.assertTrue((boolean)logger.isDebugEnabled());
            Assert.assertTrue((boolean)logger.isEnabledFor(Level.DEBUG));
        } else {
            Assert.assertFalse((boolean)logger.isDebugEnabled());
            Assert.assertFalse((boolean)logger.isEnabledFor(Level.DEBUG));
        }
        if (5000 >= threshold.levelInt) {
            Assert.assertTrue((boolean)logger.isTraceEnabled());
            Assert.assertTrue((boolean)logger.isEnabledFor(Level.TRACE));
        } else {
            Assert.assertFalse((boolean)logger.isTraceEnabled());
            Assert.assertFalse((boolean)logger.isEnabledFor(Level.TRACE));
        }
    }

    @Test
    public void testEnabled_All() throws Exception {
        this.root.setLevel(Level.ALL);
        this.checkLevelThreshold(this.loggerTest, Level.ALL);
    }

    @Test
    public void testEnabled_Debug() throws Exception {
        this.root.setLevel(Level.DEBUG);
        this.checkLevelThreshold(this.loggerTest, Level.DEBUG);
    }

    @Test
    public void testEnabled_Info() throws Exception {
        this.root.setLevel(Level.INFO);
        this.checkLevelThreshold(this.loggerTest, Level.INFO);
    }

    @Test
    public void testEnabledX_Warn() throws Exception {
        this.root.setLevel(Level.WARN);
        this.checkLevelThreshold(this.loggerTest, Level.WARN);
    }

    public void testEnabledX_Errror() throws Exception {
        this.root.setLevel(Level.ERROR);
        this.checkLevelThreshold(this.loggerTest, Level.ERROR);
    }

    @Test
    public void testEnabledX_Off() throws Exception {
        this.root.setLevel(Level.OFF);
        this.checkLevelThreshold(this.loggerTest, Level.OFF);
    }

    @Test
    public void setRootLevelToNull() {
        try {
            this.root.setLevel(null);
            Assert.fail((String)"The level of the root logger should not be settable to null");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setLevelToNull_A() {
        this.loggerTest.setLevel(null);
        Assert.assertEquals((Object)this.root.getEffectiveLevel(), (Object)this.loggerTest.getEffectiveLevel());
    }

    @Test
    public void setLevelToNull_B() {
        this.loggerTest.setLevel(Level.DEBUG);
        this.loggerTest.setLevel(null);
        Assert.assertEquals((Object)this.root.getEffectiveLevel(), (Object)this.loggerTest.getEffectiveLevel());
    }

    @Test
    public void setLevelToNull_LBCLASSIC_91() {
        this.loggerTest.setLevel(Level.DEBUG);
        Logger child = this.lc.getLogger(this.loggerTest.getName() + ".child");
        this.loggerTest.setLevel(null);
        Assert.assertEquals((Object)this.root.getEffectiveLevel(), (Object)this.loggerTest.getEffectiveLevel());
        Assert.assertEquals((Object)this.root.getEffectiveLevel(), (Object)child.getEffectiveLevel());
    }
}

