/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.boolex;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.boolex.JaninoEventEvaluator;
import ch.qos.logback.classic.pattern.ConverterTest;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.Matcher;
import ch.qos.logback.core.pattern.FormattingConverter;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.MarkerFactory;

public class JaninoEventEvaluatorTest {
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(ConverterTest.class);
    Matcher matcherX = new Matcher();
    static final long LEN = 10000L;

    public JaninoEventEvaluatorTest() {
        this.matcherX.setName("x");
        this.matcherX.setRegex("^Some\\s.*");
        this.matcherX.start();
    }

    LoggingEvent makeLoggingEvent(Exception ex) {
        LoggingEvent e = new LoggingEvent(FormattingConverter.class.getName(), this.logger, Level.INFO, "Some message", (Throwable)ex, null);
        return e;
    }

    @Test
    public void testBasic() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("message.equals(\"Some message\")");
        jee.setContext((Context)this.loggerContext);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        Assert.assertTrue((boolean)jee.evaluate((Object)event));
    }

    @Test
    public void testLevel() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("level > DEBUG");
        jee.setContext((Context)this.loggerContext);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        Assert.assertTrue((boolean)jee.evaluate((Object)event));
    }

    @Test
    public void testtimeStamp() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("timeStamp > 10");
        jee.setContext((Context)this.loggerContext);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        Assert.assertTrue((boolean)jee.evaluate((Object)event));
    }

    @Test
    public void testWithMatcher() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("x.matches(message)");
        jee.setContext((Context)this.loggerContext);
        jee.addMatcher(this.matcherX);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        Assert.assertTrue((boolean)jee.evaluate((Object)event));
    }

    @Test
    public void testMarker() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("marker.contains(\"BLUE\")");
        jee.setContext((Context)this.loggerContext);
        jee.addMatcher(this.matcherX);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        event.setMarker(MarkerFactory.getMarker((String)"BLUE"));
        Assert.assertTrue((boolean)jee.evaluate((Object)event));
    }

    @Test
    public void testWithNullMarker() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("marker.contains(\"BLUE\")");
        jee.setContext((Context)this.loggerContext);
        jee.addMatcher(this.matcherX);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        try {
            jee.evaluate((Object)event);
            Assert.fail((String)"We should not reach this point");
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
    }

    @Test
    public void testComplex() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("level >= INFO && x.matches(message) && marker.contains(\"BLUE\")");
        jee.setContext((Context)this.loggerContext);
        jee.addMatcher(this.matcherX);
        jee.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        event.setMarker(MarkerFactory.getMarker((String)"BLUE"));
        Assert.assertTrue((boolean)jee.evaluate((Object)event));
    }

    @Test
    public void testBogusExp1() {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("mzzzz.get(\"key\").equals(null)");
        jee.setContext((Context)this.loggerContext);
        jee.setName("bogus");
        jee.start();
        Assert.assertFalse((boolean)jee.isStarted());
    }

    @Test
    public void testBogusExp2() {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("mdc.get(\"keyXN89\").equals(null)");
        jee.setContext((Context)this.loggerContext);
        jee.setName("bogus");
        jee.start();
        Assert.assertTrue((boolean)jee.isStarted());
        LoggingEvent event = this.makeLoggingEvent(null);
        for (int i = 0; i < 4; ++i) {
            try {
                jee.evaluate((Object)event);
                Assert.fail((String)"should throw an exception");
                continue;
            }
            catch (EvaluationException e) {
                // empty catch block
            }
        }
        Assert.assertFalse((boolean)jee.isStarted());
    }

    void loop(JaninoEventEvaluator jee, String msg) throws Exception {
        LoggingEvent event = this.makeLoggingEvent(null);
        int i = 0;
        while ((long)i < 10000L) {
            jee.evaluate((Object)event);
            ++i;
        }
    }

    @Test
    public void testLoop1() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("timeStamp > 10");
        jee.setContext((Context)this.loggerContext);
        jee.start();
        this.loop(jee, "timestamp > 10]: ");
    }

    @Test
    public void testLoop2() throws Exception {
        JaninoEventEvaluator jee = new JaninoEventEvaluator();
        jee.setExpression("x.matches(message)");
        jee.setContext((Context)this.loggerContext);
        jee.addMatcher(this.matcherX);
        jee.start();
        this.loop(jee, "x.matches(message): ");
    }
}

